# -*- coding: utf-8 -*-

from django.db.models import Q

from gm_rpcd.all import bind

from talos.services.soft_article.soft_article import SoftArticleService
from talos.models.tractate import Tractate
from talos.models.soft_article import SoftArticle


@bind('mimas/soft_article/select_list')
def list_soft_article_for_select(doctor_id, offset=0, count=10):
    """获取医生帖子"""

    result = {
        "soft_articles": [],
    }

    if not doctor_id:
        return result

    tractates = SoftArticleService.get_soft_article_objs_by_query_and_order(
        query=Q(is_online=True, doctor_id=doctor_id), order_by=["id"],
        need_section=True, offset=offset, size=count
    )

    result["soft_articles"] = list(tractates.values("id", "title"))

    return result


@bind('mimas/soft_article/hera_choice')
def soft_article_select(initial, page=0, num=10):
    """hera获取医生帖子"""

    result = []
    data = SoftArticle.objects.filter(pk__in=initial)
    for item in data:
        result.append({"id": item.id, "text": '{}:{}'.format(item.id, item.title)})
    return {'results':result}


@bind('mimas/tractate/hera_choice')
def tractate_select(initial, page=0, num=10):
    """hera获取用户帖子"""
    result = []
    data = Tractate.objects.filter(pk__in=initial)
    for item in data:
        result.append({"id": item.id, "text": '{}:{}'.format(item.id, item.content)})
    return {'results':result}
