from gm_rpcd.all import bind
from gm_types.error import ERROR
from gm_types.gaia import (
    REPORT_REASON,
)

from talos.services.tractate.report import ReportService
from utils.rpc import get_current_user, gen


@bind('mimas/tractate/report')
def tractate_report(reason_id, tractate_id=None, reply_id=None):
    """
    举报 帖子
    :param reason_id:
    :param tractate_id:
    :param reply_id:
    :return:
    """
    user = get_current_user()
    if not user:
        return gen(ERROR.LOGIN_REQUIRED)

    if not reason_id or (not any([tractate_id, reply_id])):
        return gen(ERROR.PARAMS_INCOMPLETE)

    if reason_id not in REPORT_REASON:
        return gen(ERROR.PARAMS_INCOMPLETE)

    ReportService.create(user_id=user.id, reason_id=reason_id, tractate_id=tractate_id, reply_id=reply_id)

    return gen(ERROR.SUCCESS)
