from multiprocessing import Manager, Pool

from .init_user_rights_base import *


manager = Manager()
va = manager.list()


@trace_unhandled_exceptions
def process_create_topic(line):
    _d = json.loads(line)

    # 剔除脏数据
    if not _d['author_id']:
        return

    if _d['is_operation'] == SERVICE_TYPE.OPERATION:
        v = push_event(event_type=EventType.CREATEOPERATIONTOPIC, trigger_time=_d['trigger_time'],
                       user_id=_d['author_id'], item_id=_d['topic_id'])
        print(v)
    else:
        v = push_event(event_type=EventType.CREATENONOPERATIONTOPIC, trigger_time=_d['trigger_time'],
                       user_id=_d['author_id'], item_id=_d['topic_id'])
        print(v)


class Command(BaseCommand):

    def handle(self, *args, **options):
        # topic
        print('------start-----')
        start_time = time.time()
        print(start_time)

        with open(path_base + 'topic_infos.txt', 'r') as f:
            lines = f.readlines()
            pool = Pool(processes=4)
            pool.map(process_create_topic, lines)
            pool.close()
            pool.join()

        end_time = time.time()
        print(end_time)
        print('use {} s'.format(end_time - start_time))
        print('Done!')
