import traceback
import functools
import json
import time

from django.core.management import BaseCommand
from gm_types.user_hierarchy import EventType
from gm_types.gaia import SERVICE_TYPE, DIARY_CONTENT_LEVEL

from user_hierarchy.manager.event_dispatcher import EventDispatcher


dispatcher = EventDispatcher()


def push_event(event_type, trigger_time, user_id, item_id=None, pre_payment=None):
    event_handler = dispatcher.dispatch(event_type, trigger_time, user_id, item_id, pre_payment)
    value = event_handler.process()
    return value

path_base = '/tmp/'


def trace_unhandled_exceptions(func):
    @functools.wraps(func)
    def wrapped_func(*args, **kwargs):
        try:
            func(*args, **kwargs)
        except:
            with open('error.txt', 'a') as f:
                f.write('Exception in '+func.__name__)
                f.write('\n')
                f.write(str(args[0]))
                f.write('\n')
            # print('Exception in '+func.__name__)
            # traceback.print_exc()
    return wrapped_func
