from gm_types.gaia import USER_RIGHTS_LEVEL
from django.conf import settings


def get_last_level():
    return USER_RIGHTS_LEVEL.V7


def get_next_level_by_level(level):
    last_level = get_last_level()
    if level == last_level:
        return None
    return str(int(level) + 1)


def get_level_by_value(value):
    last_level = get_last_level()
    if last_level not in settings.LEVEL_START_VALUE.keys():
        raise NotImplemented

    if value >= settings.LEVEL_START_VALUE[last_level]:
        return last_level

    for i in range(1, int(last_level)):
        now_level = str(i)
        next_level = get_next_level_by_level(now_level)
        value_range = range(settings.LEVEL_START_VALUE[now_level], settings.LEVEL_START_VALUE[next_level])
        if value in value_range:
            return now_level
