# coding=utf-8

from django.dispatch import receiver
from django.db.models.signals import post_save

from gm_types.gaia import INDEX_CARD_TYPE
from gm_types.user_hierarchy import FEEDBACK

from qa.models.answer import Answer
from talos.models.tractate import Tractate
from talos.models.diary import Diary

from user_hierarchy.models import UserFeedback


@receiver(post_save, sender=UserFeedback)
def user_feedbacke_post_save(sender, instance, created, **kwargs):

    if not created:
        return

    if instance.feedback_type != FEEDBACK.LOW_QUALITY:
        return

    if instance.element_type == INDEX_CARD_TYPE.DIARY:
        model = Diary
    elif instance.element_type == INDEX_CARD_TYPE.QUESTION_ANSWER:
        model = Answer
        # class AnswerForm
    elif instance.element_type == INDEX_CARD_TYPE.TRACTATE:
        model = Tractate
        # class TractateForm(forms.Form):
    else:
        return

    try:
        item = model.objects.get(id=instance.element_id)
    except:
        return

    item.low_quality += 1
    item.save()
