-- Deploy gm-face:add_table_user_hierarchy to mysql

BEGIN;

CREATE TABLE `api_user_event_log` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `trigger_time` datetime(6),
    `created_time` datetime(6) NOT NULL,
    `event_type` varchar(2) NOT NULL,
    `related_item_id` varchar(40),
    `value` integer DEFAULT 0
)
;
alter table api_user_event_log add index event_index(user_id,event_type);

CREATE TABLE `api_user_growth_value` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `value` integer NOT NULL,
    `level` varchar(1) default '1'
)
;

CREATE TABLE `api_growth_task` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `title` varchar(100) NOT NULL,
    `content` varchar(300) NOT NULL,
    `result` varchar(300) NOT NULL,
    `events` varchar(100) NOT NULL,
    `is_daily` bool DEFAULT 1 NOT NULL
    )
    ;

COMMIT;
