# coding:utf-8

from django.core.management import BaseCommand
from gm_types.mimas import FAKE_REPLY_BAND_TYPE

from communal.models.fake_reply import FakeReplyPool, FakeReplyConfig, FakeReplyConfigMapReply

# 标签池
tag_id = 2137
tag_replies = [
    "谁能不爱这颜值", "每日看好看的脸回血", "你真是生活动力", "我太爱你的颜值了", "舔屏", "长得好看，横着竖着斜着拍都好看",
    "太优越了", "优越本人", "暴击", "盛世美颜", "这是什么绝世颜值啊", "来品品这个style", "来品品这个风格", "除了哇我还能说什么",
    "真的是好看呢", "这颜值，可真的是顶不住了", "咋就这么好看呢", "这颜值超级超级棒哦！", "你真的好好看", "好看到起鸡皮疙瘩",
    "好看的立刻粉了", "这个照片不够看的，求更多", "太击中我了", "诚邀各位欣赏这盛世美颜啊", "请问这是什么神仙颜值", "颜值真的太高了",
    "好看到合不拢嘴，想要联系方式", "哇，一直在感叹", "看一万遍还是看不够", "破音呐喊，太好看啦", "咦，谁在发光哦",
    "发什么都美呆了!", "好看的人就是治愈良药", "期待你的每天更新", "看你就是是生活必备品", "每日看一万遍好看的颜值", "不愧是你",
    "真的很吃这种颜", "不愧是宁", "点进来就出不去了", "谁看了能不爱", "真的喜欢这个风格", "对这种风格无法抵抗", "我没法冷静了",
    "都给我看！", "神仙颜值没错了", "我真实的发出尖叫声", "我来了！！！这个系列都好看", "神仙颜值！摇旗呐喊", "对这种颜无法抵抗",
    "颜值大发", "是什么神仙颜值呢", "当场昏厥", "这是什么绝色啊", "绝色！！", "颜狗来了！", "真的可太棒了呢", "好看到词穷",
    "随便拍都会好看的", "在发光啊", "怎么拍都好看啊", "这什么颜值!", "为你喊破喉咙", "什么都做得好", "你好看的让我魂牵梦绕",
    "顶不住啊顶不住", "超超超超美的", "颜值模板吧你，太好看了", "很想知道滤镜，太好看了吧！", "你咋这么好看", "疯狂鸡叫",
    "好看的人怎么拍都好看", "一秒内爱上", "awsl", "进来看颜王的照片", "美美哒", "你怎么这么好看呢", "我天，真好看",
    "我的妈!你超美啊！", "爱辽", "心动辽", "你怎么可以这么好看", "同款姿势可以拥有，颜值拥有不了了。", "可惜国家不分配颜值",
    "长得好看是王道", "好看的人随便怎么拍都在这么好看", "这个颜值，怕是要在线夺命", "谁能不喜欢呢", "你简直是就是优越本身",
    "你简直是是优越代名词", "你好看到仿佛是来索命的", "哇惊叹着", "你真的是宝藏，太好看了", "你是什么宝藏哦，偷偷摸摸关注一下",
    "神仙颜值！！！", "你也太好看了吧！！！", "你好好看啊，好喜欢你的颜值", "你真的好好看！！", "哇，你也太好看了",
    "哇，你是什么神仙颜值！", "你的颜是我吃的那一挂哎", "这颜值是我喜欢的类型了", "这颜值是长在我的上审美了",
    "这颜真是长我审美点上了", "哇塞，好可爱啊", "好可爱啊", "喜欢！太可爱了", "哇塞，喜欢这个颜值", "粉了粉了",
    "我是你的颜值粉", "这颜值戳到我了", "神仙颜值", "是戳我审美点的颜了", "是戳我审美点的可爱哇", "是戳我审美点的好看哇",
    "喜欢这个发色", "脸型好棒", "这个鼻子是我的爱", "颜值好好看", "这个颜值一定是穿什么都好看", "想学习这个妆容",
    "是戳我审美点的眼睛了", "是戳我审美点的高鼻梁了", "是戳我审美点的唇形了", "是戳我审美点的眉毛了", "五官好精致啊",
    "眼睛真的好看", "脸型好棒啊，喜欢这个脸型", "鼻子好好看", "整体看着好舒服", "喜欢这种风格", "这构图很好啊",
    "想学习你的拍照技巧", "这什么神仙颜值！！！！", "人好看还会还会拍", "人这么好看还会拍，慕了！", "羡慕长得好看的人",
    "羡慕给你拍照的人", "颜粉儿来报道", "怎么会这么好看的人！", "是戳我审美点的发色了", "是戳我审美点的发型了",
    "你的头发，眼睛，鼻子，仿佛都长成了我最爱的样子", "怎么会有人长得和我喜欢的样子这么像", "喜欢你的颜值！！", "这是什么神仙颜值诶~",
    "好看到直戳我心", "看完你的照片。心跳漏一拍", "可以得到你的联系方式吗。", "立刻粉了！喜欢这个颜值", "等到你的新照片，开心",
    "颜值一级！", "请你每天多更几张照片好吗", "图片是加滤镜了吗 真好看呀", "这个颜值我真的是欲罢不能，看了好几遍",
    "我会告诉你我看了好几遍吗", "立刻粉了，为了这个颜值", "ღ( ´･ᴗ･` )比心", "给你笔芯", "在线比心漂亮姐姐", "给这个颜值在线打call",
    "给你，我的小心心", "请收下我的小心心", "请收下我的疯狂笔芯", "给你我所有的爱意，喜欢！", "怎么会这么好看。老天造人不公平",
    "这颜值，人生肯定特别顺利", "为你在线打call", "可盐可甜的风格！", "什么风格都好看！", "这无处安放的魅力啊", "立刻粉了！！",
    "第一张也太好看了吧！", "喜欢喜欢，在线打call", "我是你的颜值粉，请多更新好吗", "这张和我的同学好像！",
    "我，我，我，可以认识你吗", "又好看又会拍", "喜欢了！", "神仙颜值，每天都想催更新", "为这个神仙颜值打call！！！",
    "这个颜值真的是我的最喜欢的那一卦！", "平时不发言，但这个颜值我必须说话！", "不爱说话的我，必须发言了。喜欢你",
    "这个角度能hold，长得好看果然可以随便拍", "这个角度能抗住，这得什么神仙颜值", "这个角度还这么好看啊", "又好看又会拍照，厉害了",
    "你怎么这么好看", "真的太美了我很喜欢！！", "你以为你长得美就可以不回我吗", "好好看 我哭 我什么时候可以再好看一点",
    "真的是 喜欢到不行！", "好好看呀 我也想拍这么好看的", "我对你的爱意值高达百分之两百噢", "喜欢各种各样的你  嘿嘿",
    "哇哦 这是谁的神仙大宝贝啊", "为什么会有这么好看的人", "超爱这种感jio！！！！！", "每天看到这么好看的颜，美梦鸭",
    "是我梦想的颜值", "完全就是我喜欢的类型吧！", "吼吼看呀美颜暴击", "总是莫名的 怎么照都好看", "人美怎样拍都好看",
    "这是什么神仙颜值 爱liao 爱liao", "该有的感觉你都有", "不说啥了。只想夸夸这神仙颜值", "博主的颜真耐打", "都好看到哭啊，小北鼻",
    "第一瞬间就戳中了我", "嘤嘤嘤 我都爱死了！！", "我要有这么好看我也很爱自拍了", "因为好看 所以爱自拍", "真的长的超级精致",
    "一直都超喜欢看你的照片哎", "不行了 我 你太好看了我要晕倒了", "您也是真的hin好看诶", "会拍你就多拍点 顺便也多发点哈哈哈哈 可爱^_^",
    "看来老天确实不是公平的", "实名制羡慕！", "天啦！我第一次看到这么好看的人！！！", "到底为什么会这么好看！！！",
    "这也太好看啦叭 一眼沦陷 我对你 就是爱！死！了！", "大概是从天而降的仙女吧", "太美了 我宣布我已经血空",
    "为什么会有这么好看的人在人间", "天啦噜！！！这也太好看了", "这谁顶得住啊太好看了！", "我希望我在梦里可以长这个样子",
    "这到底是什么仙女了啦", "啊啊啊啊啊啊看到这么美的你！俺心情也好好！", "看到美女心情就更好啦！！！", "甜甜的你 温暖我的心",
    "请问如何才能像博主一样美", "这么美丽冻人直戳人心真的好吗", "哭唧唧看这里！！！！好看哭泣", "究竟怎么做到这种妆容的 有点爱",
    "你是人间天使吗？", "果然人好看怎么拍都好看呢", "您真是好看极了!!", "请告诉我怎么拍都好看的秘诀", "太好看了吧 皮卡皮卡",
    "亲亲 那么好看建议你多拍哦", "我真的夸不动了，为什么有这么可爱美丽的女孩纸", "真的好美，你到底要让我夸多少遍才够",
    "太好看了8 永远看不够", "看你我就觉得可以开心一年接着一年", "我的宝藏女孩 啊啊真滴太美了 人间仙女",
    "真的太美了！怎么会有这么美的女孩", "这是什么美丽的精灵", "嘻嘻，好美一女的，爱了爱了", "被天使亲吻过的脸",
    "太美了，我要窒息了", "未闻花名 但知其人", "太美了！！！一眼沦陷！", "爱死了你这个颜值", "哇哇哇，你也太好看了叭",
    "太好看了吧！！救命！！", "好了 这个真的美哭了", "啊我心中的天使", "妈呀，你也太好看了吧", "说不出哪里喜欢 就是哪哪都喜欢",
    "求求您 停止散发你的魅力！！！！！", "特别有气质，加油", "好美啊，初恋的面孔", "我天，真的太好看了", "本颜粉儿来报道啦",
    "是神颜没错了", "为什么可以这么好看", "我死了 你为什么这么好看，我就地死亡", "画里走出来的叭", "太美了吧我看呆了555",
    "我也要像你一样闪闪发光", "这个真的超级美丽了", "这是什么散落人间的仙子", "我天……这是什么神仙颜值", "这神仙颜值，立刻粉了",
    "wei，110吗，这里有人好看到让我想报警诶!", "太好看了吧 ！哭泣了", "好看到爆炸(｡･ω･｡)ﾉ♡",
]

# 大组池
group_id = 32
group_replies = [
    "医生技术水平太重要了", "北京求推荐", "谢谢分享涨知识了", "美就行了", "算是比较成功的了", "这需要花很多钱吧", "整的真的很好看呀", "谁说非天然不好看呢", "好爱这个颜呀", "这张脸花多少钱都值得", "这位小姐姐也是蛮拼的呢", "看来整容还是要适合自己的", "想拥有这张脸", "好专业呀，感觉现在自己都要看懂了", "原来她做了这几个项目呀", "我也想要这种巴掌脸", "她真的就像是天生的脸呀", "第一眼看就是原生脸呀", "太意外了吧，她居然是整出来的", "做的真的是成功哦", "现在美丽就是好，哈哈", "其实还是底子好吧", "感觉自己也有希望变美女了", "果真是需要do几次才能完美", "我可以说她的脸太完美了吗", "心服口服外加佩服", "我也做过她这个项目，没有她美啊", "她是找的什么医生和医院呀", "羡慕拥有好容貌的人", "动了脸才有希望做明星呀", "看来要想上镜好看，还是需要做一下", "看了这篇分析感觉自己又有信心去do了", "简直是天翻地覆的改变呀", "她之前也还可以呀", "感觉整之前就已经蛮清秀了", "还是看她现在的模样更舒服", "我怎么感觉她原来就是这个样子呀", "不管怎样，我是磕了她的颜", "感觉自己和她之前的素颜有点像", "换个头，太值了", "美了之后感觉她事业都火了起来", "现在这个五官也好适合她呀", "真想知道给她做手术的医生，也太厉害了吧", "做的很自然呀，看起来蛮原生态的呢", "现在也是走的自然风呢", "现在真的是美的就像天生呀", "果然人生不是天生", "天生不够，后天医美来凑", "我也可以跟着她去整一下啦", "简直不敢相信她原来是这样的呢", "求科普她的医院", "她们需要定期去维护吗", "想知道医生", "真的是我喜欢的长相", "现在的长相很让人舒服", "不知道我整后会是什么效果呀", "自然无痕的五官调整呀", "适当的调整太重要了", "她太适合这个项目了", "只能说她的运气太好了，做了对的项目", "绝对是完美颜值", "正侧看皆可", "这是真的好看呢", "漂亮的小姐姐比比皆是", "现在的她感觉就是神仙颜值", "反正这张脸，我是爱了爱了", "可以做模板了", "可以说是最成功的整形案例了", "跪求医院地址", "我也想去做，但是应该蛮贵的吧", "终于蹲来她的颜值分析了", "看不出来整形的痕迹", "看了一定还是要去专业的医院整呀", "他们都是怎么整的这么成功呢", "上镜也太好看了", "做医美应该是最值得的投资了", "我枯了，怎么可以变化这么大啊", "原来她做了这些项目呀", "感觉她刚开始就是这个样子呢", "像换头一样的效果呢", "真是涨知识了，原来她做过这几个项目", "没想到这几个项目效果这么好呢", "看了她的变化，决定去做了", "求同款医生推荐", "现在的颜也是太能打了吧", "过程不重要，结果最重要", "变美就好了呀", "我们只是学习一下如何变美", "感觉还是蛮有自己特点的啦", "感觉她没有盲目追求流行项目，选择了适合自己的项目", "我也想变美美哒", "如果没有对比照，怎么能想到她做了这些项目呀", "真的是一点痕迹也没有呀", "还是现在的脸好看", "这姐姐确实也是个狠人呀", "她也太厉害了，do了这么多呢", "多学习，变美路上不迷路", "整形的顺序很重要啊", "一定要有金钱做支撑呀", "想去做同款了呀", "长见识了，分析的真到位", "写的真到位", "真是不看不知道！学到了", "这颜值简直是长在了我的审美点上", "这份秘籍我收下了", "这个造型一百分", "简直就是神仙长相", "原来是这样的，学习到了", "潜力股本股了！", "写的很对啊！", "分析的很对，真是长见识", "天然脸跟整容脸，中间就差一篇你的文章！", "这个做的是真的自然", "你不分析我都看不出来做过", "整容没有极限，只有适不适合", "这个改造的好自然啊！", "真的是没有花钱的不是", "看到你的分析，我都有点心动了", "写的好棒，也太干货了吧", "整不整的，反正现在是美丽的", "这五官简直太协调了", "羡慕这种五官协调的人", "以后多发点这种干货吧", "对于医美新手，满满的干货", "说的很有道理啊", "这个整的我给一百分", "哎呀，我好喜欢这双眼睛", "人一瘦真的怎么看都好看", "这个分析的真对", "因为你的分析以后决定坚持看你的内容了", "感觉整个人的气质都发生变化了", "看来身材比例也很重要", "谢谢你的用心分享", "这个方法真的很受用", "你说的这个方法好，我要试一试", "说的在理呢，支持你", "看到就是学到，学习了", "这个分析的真到位，学会了", "我跟她的情况有点类似，码住！", "你说的全对", "分析的到位哦", "喜欢看你写这些", "抱着一颗八卦的心，却学到了干货", "你简直就是我的医美导师", "这个说的很恰当啊", "原来整形还可以这么自然", "如果不是你分析，我都看不出来这里整过", "你写的这个真棒，希望可以持续更新", "我会一直关注你的内容的", "写的真好，喜欢你写的东西", "我感觉整的挺好的，喜欢", "原来她张这样，不可思议", "长见识长见识", "这篇看的真是值了", "你这个写得太好了", "分析的很在理，up！", "看到这精致的五官不得不在看看", "喜欢你写的内容，对我很有帮助的！", "漂亮的小姐姐果然谁都喜欢", "这前后对比照有点夸张呀", "原来她也动过这里啊，真的看不出来", "她整的我觉得还挺自然的", "整形拯救了她的脸哈哈", "她这个调整的太合适了吧", "整完一下就变得精致了很多", "你分享的经验真的真的真的很重要", "谢谢你的分享", "学到了很多专业的术语", "你这个说的很对呀，我也要精致一点", "我跟她情况差不多", "她简直在我的审美之上了", "她的美真的是普度众生了", "不看不知道，原来她做过这么多的项目啊", "每个明星的脸都是钱堆出来的吧！", "看她整的这么好，我也来感觉了！！！", "你写的好棒啊，以后会持续看的！", "保养好是一方面，还是要靠医美技术", "整完变化真的是大", "原生态的明星太少了，多少都得调一下", "整完是真的太好看了", "羡慕怎么能整的这么好看", "他们都是在哪里整的能恢复的这么好", "我也有相同的问题", "好奇明星为什么可以恢复的这么好", "说的好专业呀，被你种草了", "有美商真的太重要了！", "想变得跟她一样美", "分析的真的是头头是道", "看了你说的，自己都心动了", "漂亮小姐姐真的都是够拼的", "原来她做过这里啊，之前真的不知道", "看到她整过这里我都震惊了", "完全看不出来整过的痕迹", "这个做的也太成功了吧", "对自己太狠了，什么都敢尝试", "整形还是要根据自己的脸型来改变", "要跟你多学习整形的知识", "你说的好干货，学会了很多判断是否需要整形的知识", "我也有这方面的缺点", "为了变美，冲呀！！"
]


class Command(BaseCommand):
    """
    python django_manage.py reply_pool_create
    灌水评论池
    """

    def handle(self, *args, **options):

        tag_reply_ids = []
        for content in tag_replies:
            content = content.replace("\t", "").replace('"', "")
            if content:
                obj = FakeReplyPool.objects.create(content=content)
                tag_reply_ids.append(obj.id)
        band_list = [
            FakeReplyConfigMapReply(
                config_id=64,
                reply_id=reply_id,
            )
            for reply_id in tag_reply_ids
        ]
        FakeReplyConfigMapReply.objects.bulk_create(band_list)

        group_reply_ids = []
        for content in group_replies:
            content = content.replace("\t", "").replace('"', "")
            if content:
                obj = FakeReplyPool.objects.create(content=content)
                group_reply_ids.append(obj.id)
        band_list = [
            FakeReplyConfigMapReply(
                config_id=63,
                reply_id=reply_id,
            )
            for reply_id in group_reply_ids
        ]
        FakeReplyConfigMapReply.objects.bulk_create(band_list)

        print('DONE')
