from collections import defaultdict
from django.core.management import BaseCommand
from gm_types.mimas import FAKE_REPLY_BAND_TYPE

from communal.models.fake_reply import FakeReplyPool, FakeReplyConfig, FakeReplyConfigMapReply
from utils.execel import ExcelReader

missing_reply = {
    1508: '激光美肤kyc',
    1502: '唇部美化kyc',
}


class Command(BaseCommand):
    """
    python django_manage.py reply_pool_add_reply
    新增灌水评论
    """

    def handle(self, *args, **options):
        excel = ExcelReader('/tmp/reply_pool.xlsx')
        new_add_reply = defaultdict(list)
        replies = []
        for c in range(1, excel.column_number+1):
            data = excel.read_column(c)
            tag_id, tag_name = data[0], data[1]
            for i in data[2:]:
                if i:
                    i = i.replace("\t", "").replace('"', "")
                    if i:
                        new_add_reply[tag_id].append(i)
                        replies.append(
                            FakeReplyPool(
                                content=i
                            )
                        )
        FakeReplyPool.objects.bulk_create(replies)
        print('新增评论创建成功')
        # 关联
        for tag_id, replies in new_add_reply.items():
            config = FakeReplyConfig.objects.filter(
                tag_id=int(tag_id), band_type=FAKE_REPLY_BAND_TYPE.TAG,
            ).first()
            if not config:
                continue
            band_list = []
            for content in replies:
                reply = FakeReplyPool.objects.filter(content=content).first()
                if not reply:
                    continue
                band_list.append(
                    FakeReplyConfigMapReply(
                        config_id=config.id,
                        reply_id=reply.id,
                    )
                )
            FakeReplyConfigMapReply.objects.bulk_create(band_list)
        print('DONE')
