""" 灌水评论配置"""
from django.db import models
from gm_types.mimas import FAKE_REPLY_BAND_TYPE


class FakeReplyPool(models.Model):

    class Meta:
        verbose_name = '灌水评论池'
        db_table = 'api_fake_replies'

    content = models.CharField(max_length=256, null=False, verbose_name=u'评论内容')
    is_online = models.BooleanField(verbose_name="是否有效", default=True)


class FakeReplyConfig(models.Model):

    class Meta:
        verbose_name = '标签、大组配置'
        db_table = 'api_fake_reply_tag'

    band_type = models.SmallIntegerField(verbose_name='绑定类型', choices=FAKE_REPLY_BAND_TYPE)
    tag_id = models.IntegerField(verbose_name='标签ID', default=0)
    tag_attr_id = models.IntegerField(verbose_name='属性标签ID', default=0)
    tag_group_id = models.IntegerField(verbose_name='标签组ID', default=0)
    is_online = models.BooleanField(verbose_name="是否有效", default=True)


class FakeReplyConfigMapReply(models.Model):
    class Meta:
        verbose_name = '标签、大组绑定评论'
        db_table = 'api_fake_config_map_reply'

    config_id = models.IntegerField(verbose_name='配置ID', db_index=True)
    reply_id = models.IntegerField(verbose_name='灌水评论ID', db_index=True)
    is_online = models.BooleanField(verbose_name="是否有效", default=True)
