#!/usr/bin/env python
# -*- coding: utf-8 -*-

# 实时推送
import json

from django.conf import settings

from .push_base import (
    push_logger,
    PushServiceBase,
)
from .push_builder import PushEvents


class TimelyPushService(PushServiceBase):
    """
    实时推送 service
    """
    _default_cache_name = "timely_push"
    ratelimit_unit_times = 2  # 默认的单位时间推送数量
    ratelimit_whole_rate_limit = settings.PUSH_RATE_LIMIT_SETTINGS.get("total_count", 10)  # 一天推送总数
    push_handlers = PushEvents.timely_push_handlers

    # < ----------- push begin ------------ >
    @classmethod
    def push(cls, user_ids, action_type, **kwargs):
        """
        实时 推送
        :return:
        """
        params = cls.build_push_params(user_ids, action_type, **kwargs)
        if params:
            from communal.tasks import push_control_task
            task_ = push_control_task.delay(**params)
            push_logger.info(json.dumps({
                "step": 6,
                "sole_sign": kwargs.get("sole_sign", ""),
                "resume": "push information completed! timely push tasks delay.",
                "params": params,
                "task_id": task_.id,
            }))
    # < ----------- push end ------------ >
