from gm_types.mimas import FAKE_REPLY_BAND_TYPE, COMMUNITY_CONTENT_TYPE, FAKE_TYPE

from communal.services.fake.fake_behavior import FakeBehaviorService
from talos.rpc import bind
from talos.services.other import get_user_lastest_device_app_version_by_user_id
from utils.common import is_version_gray


@bind('mimas/fake/create')
def fake_create(business_id, business_type, business_level, fake_type, fake_user_id, author_id):
    """
    灌水
    :param business_id:
    :param business_type: COMMUNITY_CONTENT_TYPE
    :param business_level: 2，3，4，5，6
    :param fake_type: FAKE_TYPE
    :param fake_user_id:
    :param author_id:
    :return:
    """
    version = get_user_lastest_device_app_version_by_user_id(author_id)
    # 推送跳转到消息页的赞列表
    jump_to_vote_list = is_version_gray(version, '7.29.0')
    if business_type == COMMUNITY_CONTENT_TYPE.ANSWER:
        if fake_type == FAKE_TYPE.COMMENT:
            FakeBehaviorService.answer_reply(int(business_id), int(fake_user_id), author_id)
        elif fake_type == FAKE_TYPE.VOTE:
            FakeBehaviorService.answer_vote(int(business_id), int(fake_user_id), author_id, jump_to_vote_list=jump_to_vote_list)
        elif fake_type == FAKE_TYPE.QUALITY:
            FakeBehaviorService.answer_quality(int(business_id), int(fake_user_id), author_id)

    elif business_type == COMMUNITY_CONTENT_TYPE.TOPIC:
        if fake_type == FAKE_TYPE.COMMENT:
            FakeBehaviorService.topic_reply(int(business_id), int(fake_user_id), author_id)
        elif fake_type == FAKE_TYPE.VOTE:
            FakeBehaviorService.topic_vote(int(business_id), int(fake_user_id), author_id, jump_to_vote_list=jump_to_vote_list)

    elif business_type == COMMUNITY_CONTENT_TYPE.TRACTATE:
        if fake_type == FAKE_TYPE.COMMENT:
            FakeBehaviorService.tractate_reply(int(business_id), int(fake_user_id), author_id)
        elif fake_type == FAKE_TYPE.VOTE:
            FakeBehaviorService.tractate_vote(int(business_id), int(fake_user_id), author_id, jump_to_vote_list=jump_to_vote_list)
