import logging
from talos.models.soft_article.soft_article import SoftArticle, SoftArticleRelation
from data_sync.utils import to_epoch, tzlc
from qa.models.toutiao import by_content_type_id_get_keywords, get_content_star_keywords, get_content_title_keywords, get_content_star_first_keyword


def get_soft_article(pks):
    doctor_tractates = SoftArticle.objects.filter(id__in=pks)
    data = []
    for doctor_tractate in doctor_tractates:
        item = {}
        item['id'] = doctor_tractate.id
        item["content"] = doctor_tractate.content
        item['is_video'] = doctor_tractate.get_is_video
        item["doctor_id"] = doctor_tractate.doctor_id  # TODO mapping改成string
        # item["content_pre"] = doctor_tractate.content
        item["is_online"] = doctor_tractate.is_online
        item["status"] = doctor_tractate.status
        item["platform"] = doctor_tractate.platform
        item["content_level"] = doctor_tractate.content_level
        item["create_time"] = tzlc(doctor_tractate.create_time)
        item["tractate_tag_list"] = doctor_tractate.get_tag_list_sort_article
        item["content_keyword"] = by_content_type_id_get_keywords(id=doctor_tractate.id, content_type="doctortopic")
        # item["content_star_keyword"] = get_content_star_keywords(id=doctor_tractate.id, content_type="doctortopic")
        # item["content_star_first_keyword"] = get_content_star_first_keyword(id=doctor_tractate.id, content_type="doctortopic")
        # item["title_keyword"] = get_content_title_keywords(id=doctor_tractate.id, content_type="doctortopic")

        data.append(item)
        logging.info("get data:%s" % data)
    return data
