class RpcCacheLayer(object):

    _prefix = "qa:rpc:"

    def __init__(self, model_name, storage, ttl=60 * 60):
        """"""

        self.model_name = model_name
        self.ttl = ttl
        self.storage = storage

    def make_key(self, key):
        return self._prefix + "%s:%s" % (self.model_name, str(key))

    def __getitem__(self, item):
        return self.storage.get(self.make_key(item))

    def __setitem__(self, key, value):
        key = self.make_key(key)
        self.storage.set(key, value, self.ttl)
