#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import openpyxl
from django.core.management.base import BaseCommand

from gm_types.mimas import QA_CONTENT_TYPE

from qa.models import Answer


def read_from_file(path):
    re_data = set()
    sheet_name = 'Sheet1'
    file_name = path + 'edit_qa_content_type.xlsx'

    wb = openpyxl.load_workbook(file_name)
    data_sheet = wb[sheet_name]
    for i, row in enumerate(data_sheet.rows):
        if i and row[1].value:
            re_data.add(int(row[1].value))

    return list(re_data)


class Command(BaseCommand):

    def handle(self, *args, **options):

        print("BEGIN")

        parent_path = os.path.dirname(os.path.dirname(__file__))

        path = parent_path + '/files/'  # 文件上传地址确定
        answer_ids = read_from_file(path)
        print(answer_ids, len(answer_ids))

        Answer.objects.filter(pk__in=answer_ids, is_online=True).update(content_type=QA_CONTENT_TYPE.VIDEO)

        print("END")