# -*- coding: UTF-8 -*-

from django.core.management import BaseCommand
from django.db.models import Max

from gm_types.mimas import QUESTION_AUDIT_STATUS

from qa.models import Question


class Command(BaseCommand):

    step = 200

    def handle(self, *args, **kwargs):

        start = 0

        questions = Question.objects.filter(pk__gt=start)[:self.step]
        while questions:
            max_id = Question.objects.filter(pk__gt=start).aggregate(max_id=Max('id'))
            Question.objects.filter(pk__gt=start, pk__lte=max_id.get('max_id')).update(audit_status=QUESTION_AUDIT_STATUS.AUDITED)
            start = max_id.get('max_id')
            print(start)
            questions = Question.objects.filter(pk__gt=start)[:self.step]
