-- Deploy mimas-qa:2020-03-26-725_qa to mysql

BEGIN;

    --
    -- Create model QualityQuestionPool
    --
    CREATE TABLE `api_quality_question_pool` (
        `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
        `create_time` datetime(6) NOT NULL,
        `update_time` datetime(6) NOT NULL,
        `title` varchar(256) NOT NULL,
        `is_online` bool NOT NULL
    );

    --
    -- Create model QualityAnswerRead
    --
    CREATE TABLE `api_quality_answer_read` (
        `id` INTEGER AUTO_INCREMENT NOT NULL PRIMARY KEY,
        `create_time` datetime ( 6 ) NOT NULL,
        `update_time` datetime ( 6 ) NOT NULL,
        `quality_question_id` INTEGER NOT NULL,
        `user_id` INTEGER NOT NULL,
        `is_read` bool NOT NULL
    );

    --
    -- Create model QualityAuthorAnswer
    --
    CREATE TABLE `api_quality_author_answer` (
        `id` INTEGER AUTO_INCREMENT NOT NULL PRIMARY KEY,
        `create_time` datetime ( 6 ) NOT NULL,
        `update_time` datetime ( 6 ) NOT NULL,
        `quality_question_id` INTEGER NOT NULL,
        `user_id` INTEGER NOT NULL,
        `content` LONGTEXT NOT NULL,
        `is_online` bool NOT NULL
    );

    --
    -- Create model QualityAuthorAnswerImage
    --
    CREATE TABLE `api_quality_author_answer_image` (
        `id` INTEGER AUTO_INCREMENT NOT NULL PRIMARY KEY,
        `create_time` datetime ( 6 ) NOT NULL,
        `update_time` datetime ( 6 ) NOT NULL,
        `quality_answer_id` INTEGER NOT NULL,
        `url` VARCHAR ( 300 ) NOT NULL,
        `width` INTEGER DEFAULT 0,
        `height` INTEGER DEFAULT 0,
        `is_online` bool NOT NULL
    );

    --
    -- Create model QualityCommonQuestion
    --
    CREATE TABLE `api_quality_classfy_question` (
        `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
        `create_time` datetime(6) NOT NULL,
        `update_time` datetime(6) NOT NULL,
        `classify_type` smallint NOT NULL,
        `tag_id` integer,
        `tag_group_id` integer,
        `question_id` integer NOT NULL,
        `is_online` bool NOT NULL
    );

    --
    -- Create model QualityQuestion
    --
    CREATE TABLE `api_quality_question` (
        `id` INTEGER AUTO_INCREMENT NOT NULL PRIMARY KEY,
        `create_time` datetime ( 6 ) NOT NULL,
        `update_time` datetime ( 6 ) NOT NULL,
        `answer_id` INTEGER NOT NULL,
        `question_id` INTEGER NOT NULL,
        `ask_cnt` INTEGER NOT NULL,
        `answer_cnt` INTEGER NOT NULL,
        `vote_cnt` INTEGER NOT NULL,
        `is_online` bool NOT NULL
    );

    --
    -- Create model QualityQuestionRead
    --
    CREATE TABLE `api_quality_question_read` (
        `id` INTEGER AUTO_INCREMENT NOT NULL PRIMARY KEY,
        `create_time` datetime ( 6 ) NOT NULL,
        `update_time` datetime ( 6 ) NOT NULL,
        `quality_question_id` INTEGER NOT NULL,
        `user_id` INTEGER NOT NULL,
        `is_read` bool NOT NULL
    );

    --
    -- Create model QualityQuestionVote
    --
    CREATE TABLE `api_quality_question_vote` (
        `id` INTEGER AUTO_INCREMENT NOT NULL PRIMARY KEY,
        `create_time` datetime ( 6 ) NOT NULL,
        `update_time` datetime ( 6 ) NOT NULL,
        `quality_question_id` INTEGER NOT NULL,
        `user_id` INTEGER NOT NULL,
        `is_online` bool NOT NULL
    );

    --
    -- Create model QualityReply
    --
    CREATE TABLE `api_quality_reply` (
        `id` INTEGER AUTO_INCREMENT NOT NULL PRIMARY KEY,
        `create_time` datetime ( 6 ) NOT NULL,
        `update_time` datetime ( 6 ) NOT NULL,
        `quality_question_id` INTEGER NOT NULL,
        `quality_answer_id` INTEGER NOT NULL,
        `replied_id` INTEGER,
        `top_id` INTEGER,
        `user_id` INTEGER NOT NULL,
        `content` LONGTEXT NOT NULL,
        `is_online` bool NOT NULL
    );

    CREATE TABLE `api_quality_reply_image` (
        `id` INTEGER AUTO_INCREMENT NOT NULL PRIMARY KEY,
        `create_time` datetime ( 6 ) NOT NULL,
        `update_time` datetime ( 6 ) NOT NULL,
        `quality_reply_id` INTEGER NOT NULL,
        `url` VARCHAR ( 300 ) NOT NULL,
        `width` INTEGER DEFAULT 0,
        `height` INTEGER DEFAULT 0,
        `is_online` bool NOT NULL
    );

    --
    -- Create model QualityUserQuestion
    --
    CREATE TABLE `api_quality_user_question` (
        `id` INTEGER AUTO_INCREMENT NOT NULL PRIMARY KEY,
        `create_time` datetime ( 6 ) NOT NULL,
        `update_time` datetime ( 6 ) NOT NULL,
        `quality_question_id` INTEGER NOT NULL,
        `answer_id` INTEGER NOT NULL,
        `question_id` INTEGER NOT NULL,
        `user_id` INTEGER NOT NULL,
        `is_online` bool NOT NULL
    );

    CREATE TABLE `api_question_favor` (
        `id` INTEGER AUTO_INCREMENT NOT NULL PRIMARY KEY,
        `create_time` datetime ( 6 ) NOT NULL,
        `update_time` datetime ( 6 ) NOT NULL,
        `question_id` INTEGER NOT NULL,
        `user_id` INTEGER NOT NULL,
        `is_online` bool NOT NULL DEFAULT 1,
        `is_read` bool NOT NULL DEFAULT 0
    );

    CREATE TABLE `api_answer_favor` (
        `id` INTEGER AUTO_INCREMENT NOT NULL PRIMARY KEY,
        `create_time` datetime ( 6 ) NOT NULL,
        `update_time` datetime ( 6 ) NOT NULL,
        `answer_id` INTEGER NOT NULL,
        `user_id` INTEGER NOT NULL,
        `is_online` bool NOT NULL DEFAULT 1,
        `is_read` bool NOT NULL DEFAULT 0
    );

    CREATE TABLE `api_quality_classify_map` (
        `id` INTEGER AUTO_INCREMENT NOT NULL PRIMARY KEY,
        `create_time` datetime ( 6 ) NOT NULL,
        `update_time` datetime ( 6 ) NOT NULL,
        `quality_classify_id` INTEGER NOT NULL,
        `question_id` INTEGER NOT NULL
    );

    CREATE TABLE `api_answer_reply_images` (
        `id` INTEGER AUTO_INCREMENT NOT NULL PRIMARY KEY,
        `create_time` datetime ( 6 ) NOT NULL,
        `update_time` datetime ( 6 ) NOT NULL,
        `url` VARCHAR ( 300 ) NOT NULL,
        `width` INTEGER DEFAULT 0,
        `height` INTEGER DEFAULT 0,
        `reply_id` INTEGER NOT NULL
    );

    CREATE INDEX `reply_id` ON `api_answer_reply_images` (`reply_id`);

    CREATE INDEX `question_id` ON `api_question_favor` (`question_id`);
    CREATE INDEX `user_question` ON `api_question_favor` (`user_id`, `question_id`);

    CREATE INDEX `quality_classify_id` ON `api_quality_classify_map` (`quality_classify_id`);
    CREATE INDEX `question_id` ON `api_quality_classify_map` (`question_id`);

    CREATE INDEX `answer_id` ON `api_answer_favor` (`answer_id`);
    CREATE INDEX `user_answer` ON `api_answer_favor` (`user_id`, `answer_id`);

    CREATE INDEX `api_quality_answer_read_a1150ab6` ON `api_quality_answer_read` (`quality_question_id`);
    CREATE INDEX `api_quality_answer_read_e8701ad4` ON `api_quality_answer_read` (`user_id`);
    CREATE INDEX `api_quality_author_answer_a1150ab6` ON `api_quality_author_answer` (`quality_question_id`);
    CREATE INDEX `api_quality_author_answer_e8701ad4` ON `api_quality_author_answer` (`user_id`);
    CREATE INDEX `api_quality_author_answer_image_a1150ab6` ON `api_quality_author_answer_image` (`quality_answer_id`);
    ALTER TABLE `api_quality_question` ADD CONSTRAINT `api_quality_question_answer_id_18ab7e92_uniq` UNIQUE (`answer_id`, `question_id`);
    CREATE INDEX `api_quality_question_fb12e902` ON `api_quality_question` (`answer_id`);
    CREATE INDEX `api_quality_question_7aa0f6ee` ON `api_quality_question` (`question_id`);
    CREATE INDEX `api_quality_question_read_e8701ad4` ON `api_quality_question_read` (`user_id`);
    CREATE INDEX `api_quality_question_read_a1150ab6` ON `api_quality_question_read` (`quality_question_id`);
    CREATE INDEX `api_quality_question_vote_a1150ab6` ON `api_quality_question_vote` (`quality_question_id`);
    CREATE INDEX `api_quality_question_vote_e8701ad4` ON `api_quality_question_vote` (`user_id`);
    CREATE INDEX `api_quality_reply_a1150ab6` ON `api_quality_reply` (`quality_question_id`);
    CREATE INDEX `api_quality_reply_a8c7d9d1` ON `api_quality_reply` (`quality_answer_id`);
    CREATE INDEX `api_quality_reply_90ea0cfb` ON `api_quality_reply` (`replied_id`);
    CREATE INDEX `api_quality_reply_20eb1cfb` ON `api_quality_reply` (`top_id`);
    CREATE INDEX `api_quality_reply_e8701ad4` ON `api_quality_reply` (`user_id`);
    CREATE INDEX `api_quality_reply_image_te6c8d6s` ON `api_quality_reply_image` (`quality_reply_id`);
    CREATE INDEX `api_quality_classfy_question_76f094bc` ON `api_quality_classfy_question` (`tag_id`);
    CREATE INDEX `api_quality_classfy_question_f067f1b7` ON `api_quality_classfy_question` (`tag_group_id`);
    CREATE INDEX `api_quality_classfy_question_7aa0f6ee` ON `api_quality_classfy_question` (`question_id`);
    CREATE INDEX `api_quality_user_question_a1150ab6` ON `api_quality_user_question` (`quality_question_id`);
    CREATE INDEX `api_quality_user_question_e8701ad4` ON `api_quality_user_question` (`user_id`);
    CREATE INDEX `api_quality_user_question_7dasf78s` ON `api_quality_user_question` (`answer_id`);
    CREATE INDEX `api_quality_user_question_daf8adsf` ON `api_quality_user_question` (`question_id`);

COMMIT;
