-- Deploy mimas-qa:qa_2020_01-21_create_table_interest_for_content_user to mysql

BEGIN;

-- XXX Add DDLs here.
CREATE TABLE `interest_for_content_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL COMMENT '业务id',
  `business_type` varchar(64) NOT NULL DEFAULT '' COMMENT '业务类型',
  `handle_date` date DEFAULT NULL COMMENT '业务产生日期',
  `push_type` tinyint(4) NOT NULL DEFAULT '64' COMMENT 'push 类型',
  `device_id` varchar(128) NOT NULL COMMENT '设备id',
  `related_id` int(11) NOT NULL COMMENT '关联id',
  `related_type` varchar(64) NOT NULL DEFAULT '' COMMENT '关联业务类型',
  `score` smallint(6) NOT NULL COMMENT 'smart_rank',
  `sort_index` smallint(6) NOT NULL COMMENT '排序',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '推送筛选状态',
  `create_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_interest_for_content_user_push_type` (`push_type`),
  KEY `idx_interest_for_content_user_status` (`status`),
  KEY `idx_interest_for_content_user_business_type_related_type` (`business_type`,`related_type`),
  KEY `idx_interest_for_content_user_sort_index_create_time` (`sort_index`,`create_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='对内容有兴趣的用户';

COMMIT;
