from gm_test import GmTestCase

from qa.tests.test_question import randstr


class DoctorTestCase(GmTestCase):

    patch_module = (
        "qa.views.answer.get_current_user",
        "qa.serializers.get_current_user"
    )

    def create_question(self):
        resp = self.call('qa/question/create', title=randstr(), content=randstr(), tags=[], images=[])
        self.assertEqual(resp['error'], 0)
        return resp['data']['question_id']

    def test_doctor_filter(self):
        resp = self.call('qa/question/doctor/filter')
        self.assertTrue(len(resp['data']['provinces']))

    def test_question_doctor_list(self):
        self.create_question()
        resp = self.call('qa/question/doctor/list', start_num=0)
        print(resp)
