# coding=utf-8

import random

from gm_types.gaia import CONST_STRINGS as const_strings
from qa.utils.time import get_daytime_countdown

try:
    xrange
except NameError:  # python3 compatible for xrange
    xrange = range


def get_countdown(repeat_times, time_range=(0, 0)):
    countdown = []
    for _ in xrange(repeat_times):
        countdown.append(random.randint(*time_range))
    return countdown


def check_time_delta(time_list, time_interval):
    new_time_list = sorted(time_list)
    for index, value in enumerate(new_time_list):
        if index != 0:
            if value - new_time_list[index-1] < time_interval:
                new_time_list[index] += time_interval
    return new_time_list


def get_async_args_v2(stat_name):
    """
    :param stat_name:
    :return: repeat: 多少人点赞, countdown: 倒计时多久开始执行, incr_range: 增加多少浏览量
    创建回答、帖子、日记帖后
    第一次：【60s-2h】：[1-2]个赞
    第二次：【2h-5h】: [1-2]个赞
    第三次：【5-10h】：[1-2]个赞
    如果是两个 分两次(两次时间间隔限制30min)
    有真实用户点赞回答、帖子、日记帖后30min触发（概率是百分之70） 仅触发一次点赞 点赞后push触发的概率是百分之20
    冗余了一下 方便以后改 = . =
    """

    vote_trigger = True if random.randint(0, 100) > 30 else False
    incr_range = [3, 11]
    hour = 60 * 60

    if stat_name == const_strings.TOPIC_VOTE_RULE1:
        countdown = [random.randint(30, 60)]
        incr_range = [2, 20]

    elif stat_name == const_strings.DIARY_VOTE:
        first_stage = get_countdown(repeat_times=1, time_range=(60, hour * 2))
        second_stage = get_countdown(repeat_times=1, time_range=(hour * 2, hour * 10))
        third_stage = get_countdown(repeat_times=1, time_range=(hour * 10, hour * 24))

        stage = first_stage + second_stage + third_stage
        sorted(stage)
        countdown = check_time_delta(stage, time_interval=hour * 0.5)

    elif stat_name == const_strings.TOPIC_VOTE:
        countdown = [0.5 * 60 * 60] if vote_trigger else []

    elif stat_name == const_strings.ANSWER_VOTE:
        countdown = [0.5 * 60 * 60] if vote_trigger else []

    elif stat_name == const_strings.TRACTATE_VOTE:
        countdown = [0.5 * 60 * 60] if vote_trigger else []

    elif stat_name == const_strings.CREATE_ANSWER_VOTE:
        first_stage = get_countdown(repeat_times=random.randint(1, 2), time_range=(60, hour * 2))
        second_stage = get_countdown(repeat_times=random.randint(1, 2), time_range=(hour * 2, hour * 5))
        third_stage = get_countdown(repeat_times=random.randint(1, 2), time_range=(hour * 5, hour * 10))

        stage = first_stage + second_stage + third_stage
        sorted(stage)
        countdown = check_time_delta(stage, time_interval=hour * 0.5)

    elif stat_name == const_strings.CREATE_TRACTATE_VOTE:
        first_stage = get_countdown(repeat_times=random.randint(1, 2), time_range=(60, hour * 2))
        second_stage = get_countdown(repeat_times=random.randint(1, 2), time_range=(hour * 2, hour * 5))
        third_stage = get_countdown(repeat_times=random.randint(1, 2), time_range=(hour * 5, hour * 10))

        stage = first_stage + second_stage + third_stage
        sorted(stage)
        countdown = check_time_delta(stage, time_interval=hour * 0.5)

    elif stat_name == const_strings.CREATE_TOPIC_VOTE:
        first_stage = get_countdown(repeat_times=random.randint(1, 2), time_range=(60, hour * 2))
        second_stage = get_countdown(repeat_times=random.randint(1, 2), time_range=(hour * 2, hour * 5))
        third_stage = get_countdown(repeat_times=random.randint(1, 2), time_range=(hour * 5, hour * 9.5))

        stage = first_stage + second_stage + third_stage
        sorted(stage)
        countdown = check_time_delta(stage, time_interval=hour * 0.5)

    else:
        countdown = []
        incr_range = [0, 0]

    return countdown, incr_range
