#!/usr/bin/env python
# -*- coding: utf-8 -*-

# 新用户注册启动流程，问题调研，勾选感兴趣的内容创建为回答

from gm_rpcd.all import bind, RPCDFaultException
from gm_types.error import ERROR
from gm_types.mimas import CONTENT_CLASS

from qa.models.answer import Answer
from qa.tools.qa_create import AnswerCreateMethod
from utils.rpc import (
    gen,
    get_current_user,
)


@bind("qa/initiate/bulk_create_answer")
def initiate_bulk_create_answer(create_data):
    """
    用户兴趣勾选，批量创建回答接口
    hmmmmmm……
    注意：此处回答关联标签，目前仅做记录
    :param create_data: [{"question_id":, "answer_content": "", "tags": []},]
    :return:
    """
    user = get_current_user()
    if not user:
        return gen(ERROR.LOGIN_REQUIRED)

    answer_ids = []
    for info in create_data:
        try:
            answer_data = AnswerCreateMethod.create(
                user=user,
                question_id=info.get("question_id", 0),
                content=info.get("answer_content", []),
                images=[],
                platform=info.get("platform", None),
                tags=info.get("tags", []),
                tag_v3_ids=info.get("tag_v3_ids", []),
                v3_attr_tag_ids=info.get("v3_attr_tag_ids", []),
                content_level=CONTENT_CLASS.BAD  # 将创建的回答审核状态状态设置为差
            )
            answer_ids.append(answer_data["id"])
        except RPCDFaultException as e:
            continue

    return answer_ids
