#!/usr/bin/env python
# -*- coding: utf-8 -*-

from gm_rpcd.all import bind, RPCDFaultException
from gm_types.error import ERROR

from qa.tools import (
    AnswerReplyCreateMethod,
    AnswerVoteCreateMethod,
)
from talos.services import UserService
from utils.rpc import (
    gen,
    logging_exception,
)


@bind("qa/irrigation/create_answer_reply")
def irrigation_create_answer_reply(user_id, answer_id, content):
    """
    灌水 创建回答评论
    :param user_id:
    :param answer_id:
    :param content:
    :return:
    """
    user = UserService.get_user_by_user_id(user_id)
    if not user:
        return gen(ERROR.USER_NOT_FOUND)
    try:
        _data = AnswerReplyCreateMethod.answer_reply_create(
            user=user,
            content=content,
            answer_id=answer_id,
            is_timely_push=True,  # 灌水 实时推送
            is_fake=True,
        )
        return gen(
            ERROR.SUCCESS,
            **{
                "answer_reply_id": _data.get("answer_reply_id", 0),
            }
        )
    except RPCDFaultException as e:
        logging_exception()
        return gen(ERROR.CONTENT_CREATE_ERROR)


@bind("qa/irrigation/create_answer_vote")
def irrigation_create_answer_vote(user_id, answer_id):
    """
    灌水，对回答点赞
    :param user_id:
    :param answer_id:
    :return:
    """
    user = UserService.get_user_by_user_id(user_id)
    if not user:
        return gen(ERROR.USER_NOT_FOUND)

    try:
        AnswerVoteCreateMethod.answer_vote_create(
            user=user,
            answer_id=answer_id,
            is_fake=True
        )
        return gen(ERROR.SUCCESS)
    except:
        logging_exception()
        return gen(ERROR.TRACTATE_VOTE_ERROR)