# coding=utf-8
import os
import logging

LOG_DIR = '/data/log/mentha/app/'

logging.basicConfig(
    level=logging.INFO,
    format='%(asctime)s %(levelname)s %(module)s.%(funcName)s Line:%(lineno)d  %(message)s',
    filename=os.path.join(LOG_DIR, 'filelog.log'),
)

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,

    'formatters': {
        'verbose': {
            'format': '%(asctime)s %(levelname)s %(module)s.%(funcName)s Line:%(lineno)d  %(message)s'
        },
        'raw': {
            'format': '%(message)s'
        }
    },

    'handlers': {
        'qiniu_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'qiniu_logger.log'),
            'formatter': 'verbose',
        },
        'tracer_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'tracer.log'),
            'formatter': 'raw'
        },
        'info_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'info_logger.log'),
            'formatter': 'verbose'
        },
        'sql_handler': {
            'level': 'DEBUG',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'info_logger.log'),
            'formatter': 'verbose'
        },
        'cache_hit_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'cache_hit.log'),
            'formatter': 'raw'
        },
        'exception_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'exception_logger.log'),
            'formatter': 'raw',
        },
        'push_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'push_logger.log'),
            'formatter': 'verbose',
        },
        'irrigation_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'irrigation_logger.log'),
            'formatter': 'verbose',
        },
        'sync_tag_mapping_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'sync_tag_mapping.log'),
            'formatter': 'verbose',
        },
    },

    'loggers': {
        'django.db.backends': {
            'handlers': ['sql_handler'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'qiniu_logger': {
            'handlers': ['qiniu_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'gm_tracer.subscribe': {
            'handlers': ['tracer_handler'],
            'propagate': False,
            'level': 'INFO'
        },
        'cache_hit_logger': {
            'handlers': ['cache_hit_handler'],
            'propagate': False,
            'level': 'INFO'
        },
        'exception_logger': {
            'handlers': ['exception_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'info_logger': {
            'handlers': ['info_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'push_logger': {
            'handlers': ['push_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'irrigation_logger': {
            'handlers': ['irrigation_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'sync_tag_mapping_logger': {
            'handlers': ['sync_tag_mapping_handler'],
            'level': 'INFO',
            'propagate': False,
        },
    },

}
