# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function

import redis
from django.conf import settings
from qa.cache.cache_v2 import RedisWrapper  # todo RedisWrapper 需要独立出来


# hot_in_24hrs_cache = RedisWrapper("hot_in_24hrs", settings.REDIS_TOPIC_1ST['default'])  # 已无调用 180411
diary_heat_score_cache = RedisWrapper('diary_heat', settings.REDIS_TOPIC_1ST['default'])
take_sofa_diary_cache = RedisWrapper('take_sofa_diary', settings.REDIS_TOPIC_1ST['default'])
high_quality_user_cache = RedisWrapper('high_quality_users', settings.REDIS['user_cache']) # todo 是否变更
# high_quality_user_cache = RedisWrapper('high_quality_users', settings.REDIS_TOPIC_1ST['default'])
doctor_tags_cache = RedisWrapper('doctor_tags', settings.REDIS_TOPIC_1ST['default'])
doctor_tagv3s_cache = RedisWrapper('doctor_tagv3s', settings.REDIS_TOPIC_1ST['default'])
wechat_cache = RedisWrapper('wechat', settings.REDIS['default']) # todo 是否变更
# wechat_cache = RedisWrapper('wechat', settings.REDIS_TOPIC_1ST['default'])

diary_pv_cache = RedisWrapper('diary_pv', settings.REDIS['view'])
# diary_pv_cache = RedisWrapper('diary_pv', settings.REDIS_TOPIC_1ST['view'])   # todo 是否变更
hospital_topics_num_cache = RedisWrapper("hospital_topics_num", settings.REDIS["default"])
user_auth_type_cache = RedisWrapper('user_auth_type_cache', settings.REDIS['user_cache'])
user_type_cache = RedisWrapper('user_type_cache', settings.REDIS['user_cache'])

# 用于社区 专栏，问答 富文本视频内容转换，临时暂存的数据
community_video_handle_cache = RedisWrapper("community_video_handle", settings.REDIS["default"])
#存储评论数目
tractate_reply_count_cache = RedisWrapper("tractate_reply_count", settings.REDIS["default"])
# 新帖子收藏数
tractate_favor_count_cache = RedisWrapper("tractate_favor_count", settings.REDIS["default"])
# 新帖子点赞数
tractate_vote_count_cache = RedisWrapper("tractate_vote_count", settings.REDIS["default"])
# 新帖子评论点赞数
tractate_reply_vote_count_cache = RedisWrapper("tractate_reply_vote_count", settings.REDIS["default"])

#医生后台帖子
soft_article_vote_count_cache = RedisWrapper("soft_article_vote_count_cache", settings.REDIS["default"])
soft_article_favor_count_cache = RedisWrapper("soft_article_favor_count_cache", settings.REDIS["default"])
soft_article_reply_count = RedisWrapper("soft_article_reply_count", settings.REDIS["default"])

#医生后台浏览量
soft_article_pv_cache = RedisWrapper('soft_article_pv_cache', settings.REDIS_TOPIC_1ST['tractate_pv_cache'])

tractate_pv_cache = RedisWrapper('tractate_cache_pv', settings.REDIS_TOPIC_1ST['tractate_pv_cache'])

#防止点赞并发处理
fake_vote_cache = RedisWrapper('fake_vote_cache', settings.REDIS_TOPIC_1ST['default'])
# 老标签-标签3数据清洗记录 完全切成新标签后此缓存可删除 keys: tag_map_tag3_record:*
tag_map_tag3_record = RedisWrapper('tag_map_tag3_record', settings.REDIS_TOPIC_1ST['default'])

'''以下是不需要前缀的'''


class _RedisWithoutprefixProxy(object):
    # add methods those are need to be hacked here
    _hacked_methods = set([
        'get', 'mget', 'hget', 'hgetall', 'rpop', 'mset'
    ])

    def __getattribute__(self, name):
        try:
            return super(_RedisWithoutprefixProxy, self).__getattribute__(name)
        except AttributeError:
            f = getattr(self.redis,  name)
            if name in _RedisWithoutprefixProxy._hacked_methods:
                def wrapper(k, *args, **kwargs):
                    data = f(k, *args, **kwargs)
                    # bug fix for py35, json.loads does accept bytes!
                    if type(data) == bytes:
                        data = data.decode()
                    return data
                return wrapper
            return f


    def __init__(self, conf):
        self.__pool = redis.ConnectionPool(**conf)
        self.redis = redis.StrictRedis(connection_pool=self.__pool)


page_cache = _RedisWithoutprefixProxy(settings.REDIS_TOPIC_1ST['page_cache'])
vote_cache = _RedisWithoutprefixProxy(settings.REDIS_TOPIC_1ST['vote_cache'])
reply_cache = _RedisWithoutprefixProxy(settings.REDIS_TOPIC_1ST['reply_cache'])
# 新版帖子收藏
favor_cache = _RedisWithoutprefixProxy(settings.REDIS_TOPIC_1ST['favor_cache'])

#针对帖子评论排序缓存
tractate_reply_cache = _RedisWithoutprefixProxy(settings.REDIS_TOPIC_1ST['tractate_reply_cache'])

# 爬取数据入库用户信息缓存
crawl_user_cache = _RedisWithoutprefixProxy(settings.REDIS_TOPIC_1ST['user_cache'])

# 灌水专用缓存
fake_cache = _RedisWithoutprefixProxy(settings.REDIS_TOPIC_1ST['fake_task'])

# pgc 帖子专用缓存
pgc_tractate_cache = _RedisWithoutprefixProxy(settings.REDIS_TOPIC_1ST['tractate_pgc_cache'])

# 日记本相关基础信息
diary_base_info_cache = RedisWrapper('diary_base_info', settings.REDIS['default'])