from django.core.management import BaseCommand
from django.conf import settings

from gm_types.gaia import REPLYOBJECT

from qa.models import Answer, AnswerReply
from talos.models.topic.topicreply import TopicReply
from talos.cache.base import reply_cache
from talos.tools.replies_tool import ReplyTool


class Command(BaseCommand):

    def handle(self, *args, **kwargs):

        PAGE_SIZE = 1000

        start_id = 0
        max_id = Answer.objects.using(settings.SLAVE_DB_NAME).raw(
            "select max(id) id from api_answer"
        )[0].id
        qs = Answer.objects.using(settings.SLAVE_DB_NAME).filter(pk__gte=start_id, pk__lte=start_id + PAGE_SIZE)
        while qs or (start_id < max_id):
            print("Answer: max_id: {max_id}, start_id: {start_id}".format(max_id=max_id, start_id=start_id))
            for answer in qs:
                try:
                    user_id = answer.question.user_id
                except:
                    continue
                if answer.user_id != user_id:
                    rt = ReplyTool(reply_cache, user_id)
                    rt.receive_answer(answer.id)

            start_id += PAGE_SIZE
            qs = Answer.objects.using(settings.SLAVE_DB_NAME).filter(pk__gte=start_id, pk__lte=start_id + PAGE_SIZE)


        start_id = 0
        max_id = AnswerReply.objects.using(settings.SLAVE_DB_NAME).raw(
            "select max(id) id from api_answer_reply"
        )[0].id
        qs = AnswerReply.objects.using(settings.SLAVE_DB_NAME).filter(pk__gte=start_id, pk__lte=start_id + PAGE_SIZE)
        while qs or (start_id < max_id):
            print("AnswerReply: max_id: {max_id}, start_id: {start_id}".format(max_id=max_id, start_id=start_id))
            for answer_reply in qs:

                reply_type = None
                if answer_reply.commented_reply_id:
                    reply_type == REPLYOBJECT.ANSWER_REPLY
                    reply_user_id = answer_reply.commented_reply.user_id
                else:
                    reply_type == REPLYOBJECT.ANSWER
                    try:
                        reply_user_id = answer_reply.answer.user_id
                    except:
                        continue

                if reply_user_id == answer_reply.user_id:
                    continue

                rt = ReplyTool(reply_cache, reply_user_id)
                if reply_type == REPLYOBJECT.ANSWER:
                    rt.receive_answer(answer_reply.id)
                elif reply_type == REPLYOBJECT.ANSWER_REPLY:
                    rt.receive_answer_reply(answer_reply.id)

            start_id += PAGE_SIZE
            qs = AnswerReply.objects.using(settings.SLAVE_DB_NAME).filter(pk__gte=start_id, pk__lte=start_id + PAGE_SIZE)


        start_id = 0
        max_id = TopicReply.objects.using(settings.SLAVE_DB_NAME).raw(
            "select max(id) id from api_topicreply"
        )[0].id
        qs = TopicReply.objects.using(settings.SLAVE_DB_NAME).filter(pk__gte=start_id, pk__lte=start_id + PAGE_SIZE)
        while qs or (start_id < max_id):
            print("TopicReply: max_id: {max_id}, start_id: {start_id}".format(max_id=max_id, start_id=start_id))
            for tr in qs:
                user_id = None
                reply_type = None
                if tr.replied_topic_id:
                    reply_type = REPLYOBJECT.TOPIC
                    try:
                        user_id = tr.replied_topic.user_id
                    except:
                        continue

                elif tr.problem_id:
                    reply_type = REPLYOBJECT.PROBLEM
                    try:
                        user_id = tr.problem.user_id
                    except:
                        continue

                elif tr.diary_id:
                    try:
                        user_id = tr.diary.user_id
                    except:
                        continue

                if user_id != tr.user_id:
                    rt = ReplyTool(reply_cache, user_id)
                    if reply_type == REPLYOBJECT.TOPIC:
                        rt.receive_topic_reply(tr.id)
                    elif reply_type == REPLYOBJECT.PROBLEM:
                        rt.receive_problem_reply(tr.id)

            start_id += PAGE_SIZE
            qs = TopicReply.objects.using(settings.SLAVE_DB_NAME).filter(pk__gte=start_id, pk__lte=start_id + PAGE_SIZE)
