"""日记本统计信息vote_count初始化。"""

import time

from django.core.management.base import BaseCommand
from django import db


class Command(BaseCommand):

    def handle(self, *args, **options):
        """更新敏感词库。

        对于老数据，敏感词只要回复那一栏勾选的，新版本的私信一栏默认勾选。此规则不适用新数据
        http://wiki.wanmeizhensuo.com/pages/viewpage.action?pageId=5486857
        """

        print('------ starting -----')
        start_time = time.time()
        print("start at: ", start_time)

        with db.connection.cursor() as cursor:
            matched_rows = cursor.execute("UPDATE api_filterword SET in_topic_chat=true WHERE in_topic_reply=true and in_topic_chat=false;")
            print("更新了{}条数据".format(matched_rows))

        end_time = time.time()
        print("end at: ", end_time)
        print('total use {} s.'.format(end_time - start_time))
        print('Done!')
