# -*- coding: utf-8 -*-

from django.utils import timezone
from django.core.management import BaseCommand

from talos.models.diary import Diary


class Command(BaseCommand):

    def handle(self, *args, **kwargs):
        d_ids = [
            16332331, 16277386, 16277373, 16277381, 17111215, 17091738, 17091064, 16957131, 16957103, 16957086,
            16957048, 16957016, 16955692, 16955603, 16955563, 16955529, 16955479, 16766660, 16706090, 16698036,
            16691053, 16612018, 16591844, 16376248, 16332306, 16332211, 16320525, 16313891, 16312529, 16298799,
            16297538, 16297517, 16297472, 16297209, 16296953, 16295424, 16295087, 16293993, 16289770, 16289752,
            16289730, 16289686, 16289667, 16289627, 16289603, 16289589, 16289556, 16289537, 16289522, 16289465,
            16289432, 16289376, 16287247, 16280393, 16280376, 16280419, 16280403, 16280428, 16280432, 16280460,
            16280496, 16280515, 16280537, 16280540, 16280546, 16280547, 16280552, 16280556, 16280570, 16280568,
            16280576, 16280579, 16280641, 16280444, 16280653, 16280446, 16280744, 16280799, 16280398, 16280852,
            16280399, 16280876, 16281010, 16280875, 16280845, 16280798, 16280846, 16280757, 16280696, 16280658,
            16280650, 16280633, 16280606, 16280622, 16280394, 16280420, 17286109, 17064793, 16698038, 17169933
        ]

        diary_ids = list(Diary.objects.filter(id__in=d_ids, is_online=True).values_list("id", flat=True))
        print(diary_ids)

        Diary.objects.filter(id__in=d_ids).update(
            is_online=False,
            last_modified=timezone.now()
        )
