from datetime import datetime

from django.core.management import BaseCommand
from django.db.models import F, Max

from talos.models.diary import Diary, DiaryRank


class Command(BaseCommand):
    def handle(self, *args, **options):
        """

        :param args:
        :param options:
        :return:
        """
        create_at = datetime.strptime("2017-01-01", "%Y-%m-%d")
        update_at = datetime.strptime("2017-06-01", "%Y-%m-%d")

        queryset = Diary.objects.filter(created_time__lt=create_at).annotate(
            update_at=Max('topics__last_modified')
        ).filter(update_at__lt=update_at)

        DiaryRank.objects.filter(diary__in=queryset).update(additional_score=F('additional_score') - 100)
        self.stdout.write(
            self.style.SUCCESS("SUCCESS")
        )
