#!/usr/bin/env python
# -*- coding: utf-8 -*-

from datetime import datetime
from django.core.management import BaseCommand
from gm_types.gaia import (
    DIARY_AUDIT_STATUS,
    DIARY_CONTENT_LEVEL,
)

from talos.models.diary import (
    Diary,
    BDDiary,
    DiaryTag,
)


class Command(BaseCommand):
    """
    mip百度提交日记本

    ps: 第一批先提交:
        最终审核日期为：2017.08.01 之后的，
        审核状态为 已审核，
        内容为 优秀，
        有美购，
        的日记本；
    剔除 项目标签：更美练习生/樱花女神
    """
    def handle(self, *args, **kwargs):
        print("BEGIN")

        start_time = datetime.strptime("2017-08-01", "%Y-%m-%d")  # 最终时间
        content_level = [DIARY_CONTENT_LEVEL.EXCELLENT, ]  # 内容等级
        exclude_tag_ids = [7110, 7097, ]  # 剔除的标签id

        submit_diary_ids = list(BDDiary.objects.filter(is_submit=True).values_list("diary_id", flat=True))
        #  剔除 满足项目标签的日记本id
        tag_diary_ids = list(
            DiaryTag.objects.filter(tag_id__in=exclude_tag_ids).values_list("diary_id", flat=True).distinct())
        exclude_diary_ids = submit_diary_ids + tag_diary_ids

        diary_ids = list(Diary.objects.filter(
            audit_time__gte=start_time,
            audit_status=DIARY_AUDIT_STATUS.AUDITED,
            content_level__in=content_level,
            service_id__isnull=False,
            is_online=True,
        ).exclude(id__in=exclude_diary_ids).values_list("id", flat=True))

        # 向bd_diary 库中写入数据
        need_submit = []
        for did in diary_ids:
            _data = {
                "diary_id": did,
                "is_submit": True,
            }
            need_submit.append(BDDiary(**_data))
        BDDiary.objects.bulk_create(need_submit)

        print("END")