#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.core.management import BaseCommand

from gm_types.mimas import QA_CONTENT_TYPE
from gm_types.mimas.qa import VIDEO_SOURCE_TYPE
from gm_types.gaia import TOPIC_TYPE

from live.tasks import set_water_mark_to_video, get_qiniu_persistent_ids

from talos.models.topic import Video, Problem
from qa.models.answer import Question, Answer

from utils.common import get_data_from_rich_text


def update_topic_video_water_mark_url():
    print("update topic video water mark begin")
    topic_video_ids = Video.objects.values_list("id", flat=True)
    for topic_video_id in topic_video_ids.iterator():
        set_water_mark_to_video.delay(topic_video_id)
    print("update topic video water mark end")


def update_rich_text_video_water_mark_url():
    print("update article video water mark begin")
    article_list = Problem.objects.filter(
        topic_type__in=[TOPIC_TYPE.USER_ARTICLE, TOPIC_TYPE.COLUMN_ARTICLE]).values("id", "answer_richtext").iterator()

    for article_info in article_list:
        article_id = article_info["id"]
        rich_text = article_info["answer_richtext"]
        if not rich_text:
            continue
        _, video_list = get_data_from_rich_text(rich_text, u'//video[not(@name="new_video")]/@src')

        if video_list:
            get_qiniu_persistent_ids.delay(
                source_id=article_id,
                video_type=VIDEO_SOURCE_TYPE.ARTICLE,
                url_list=video_list
            )

    print("update article video water mark end")

    print("update question video water mark begin")
    question_list = Question.objects.filter(content_type=QA_CONTENT_TYPE.VIDEO).values("id", "content").iterator()

    for question_info in question_list:
        _id = question_info["id"]
        rich_text = question_info["content"]
        if not rich_text:
            continue
        _, video_list = get_data_from_rich_text(rich_text, u'//video[not(@name="new_video")]/@src')

        if video_list:
            get_qiniu_persistent_ids.delay(
                source_id=_id,
                video_type=VIDEO_SOURCE_TYPE.QUESTION,
                url_list=video_list
            )

    print("update question video water mark end")

    print("update answer video water mark begin")
    answer_list = Answer.objects.filter(content_type=QA_CONTENT_TYPE.VIDEO).values("id", "content").iterator()

    for answer_info in answer_list:
        _id = answer_info["id"]
        rich_text = answer_info["content"]
        if not rich_text:
            continue
        _, video_list = get_data_from_rich_text(rich_text, u'//video[not(@name="new_video")]/@src')

        if video_list:
            get_qiniu_persistent_ids.delay(
                source_id=_id,
                video_type=VIDEO_SOURCE_TYPE.ANSWER,
                url_list=video_list
            )

    print("update answer video water mark end")


class Command(BaseCommand):

    def handle(self, *args, **kwargs):
        print("BEGIN")
        update_topic_video_water_mark_url()
        update_rich_text_video_water_mark_url()
        print("END")
