#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   18/05/04 16:57:42
#   Desc    :   日记本首页feed相关
#

from django.db.models import Model, ForeignKey, DateTimeField, IntegerField


from talos.models.diary.diary import Diary


class DiaryFeedWeight(Model):
    class Meta:
        verbose_name = '日记本首页策略调权'
        app_label = 'talos'

    diary = ForeignKey(Diary)
    start_time = DateTimeField('开始时间')
    end_time = DateTimeField('结束时间')
    weight = IntegerField('调权分', default=0)
