# coding=utf8
from __future__ import unicode_literals, absolute_import, print_function

from django.db import models
from django.utils import timezone


class ReplyCollect(models.Model):
    class Meta:
        verbose_name = u'所有的回复'
        verbose_name_plural = u'回复几何'
        app_label = 'talos'
        db_table = 'api_reply_collect'

        index_together = [('user_id', 'created_time'), ('reply_user_id', 'created_time')]

    created_time = models.DateTimeField(default=timezone.now, verbose_name=u'创建时间时间', db_index=True)
    topic_reply_id = models.IntegerField(default=None, verbose_name=u'帖子id', unique=True, null=True)
    answer_id = models.IntegerField(default=None, verbose_name=u'回答id', unique=True, null=True)
    user_id = models.IntegerField(default='', verbose_name=u'作者id')
    reply_user_id = models.IntegerField(default='', verbose_name=u'被回复者id')
