"""软文收藏"""

from django.db import models
from django.utils import timezone


class SoftArticleFavor(models.Model):
    """
    新帖子 收藏相关
    """

    class Meta:
        verbose_name = u'新帖子(软文)收藏相关'
        db_table = 'api_softarticle_favor'
        app_label = 'talos'
        unique_together = ("user_id", "softarticle_id")

    softarticle_id = models.IntegerField(verbose_name="软文id")
    user_id = models.IntegerField(verbose_name="收藏的用户id")
    is_deleted = models.BooleanField(verbose_name=u"是否取消收藏", default=False)
    is_read = models.BooleanField(verbose_name=u"是否已读", default=False)

    create_time = models.DateTimeField(verbose_name=u"收藏时间", default=timezone.now)
    update_time = models.DateTimeField(verbose_name=u"更新时间", auto_now=True)
