# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function

from django.db import models
from gm_types.gaia import VOTEOBJECT

from talos.libs.datetime_utils import get_timestamp_or_none
from talos.services.user import UserService

from .topicreply import TopicReply


class TopicReplyVote(models.Model):
    """
    赞一级评论
    """

    class Meta:
        unique_together = ('user_id', 'topic_reply')
        app_label = 'talos'
        db_table = 'api_topicreplyvote'

    user_id = models.IntegerField(verbose_name=u'用户外键id')
    topic_reply = models.ForeignKey(TopicReply, verbose_name=u"一级评论")
    vote_time = models.DateTimeField(auto_now_add=True, verbose_name=u"点赞时间")
    unread = models.BooleanField(default=True)

    @property
    def user(self):
        return UserService.get_user_by_user_id(self.user_id)

    def to_dict(self):
        user = UserService.get_user_by_user_id(user_id=self.user_id)
        data = {
            'topic_id': self.topic_reply.problem_id,
            'content': self.topic_reply.content,
            'nickname': user.nickname,
            'user_id': self.user_id,
            'vote_time': get_timestamp_or_none(self.vote_time),
            'membership_level': user.membership_level,
            'type': VOTEOBJECT.TOPIC_REPLY,
            'portrait': user.portrait,
        }
        return data

