"""帖子评论"""

from django.db import models
from django.utils import timezone

from gm_types.mimas import (
    TRACTATE_REPLY_SOURCE,
    TRACTATE_PLATFORM,
)
from gm_upload import (
    ImgUrlField,
    IMG_TYPE,
)


class TractateReply(models.Model):
    """新帖子评论相关"""

    class Meta:
        verbose_name = '新帖子评论相关'
        db_table = 'api_tractate_reply'
        app_label = 'talos'

    tractate_id = models.IntegerField(verbose_name="新帖子id", db_index=True, null=False)
    user_id = models.IntegerField(verbose_name="用户ID", null=False, db_index=True)

    top_id = models.IntegerField(verbose_name="当前评论的一级评论，一级评论为0", db_index=True)
    replied_id = models.IntegerField(verbose_name="被评论的评论id，一级评论为0", db_index=True)
    content = models.CharField(verbose_name="评论内容", max_length=512)

    is_read = models.BooleanField(verbose_name=u"是否已读", default=False)

    vote_num = models.IntegerField(verbose_name="点赞数", default=0)

    source_id = models.CharField(verbose_name="数据来源", max_length=12)  # hera、app
    is_online = models.BooleanField(verbose_name=u"是否在线", default=True)

    create_time = models.DateTimeField(verbose_name=u'创建时间', default=timezone.now)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)
    is_fake = models.BooleanField(verbose_name=u'是否是灌水评论', default=False)

    platform = models.CharField(verbose_name=u"数据来源", max_length=12, choices=TRACTATE_PLATFORM)
    platform_id = models.CharField(verbose_name=u"数据来源id", max_length=125, db_index=True)


class TractateReplyImages(models.Model):

    class Meta:
        verbose_name = u'用户帖评论图片'
        db_table = 'api_tractate_reply_images'

    reply_id = models.IntegerField(verbose_name="新帖子评论id", db_index=True)
    image_url = ImgUrlField(img_type=IMG_TYPE.TOPICIMAGE, max_length=300, verbose_name=u'图片地址')
    width = models.IntegerField(verbose_name="图片宽度", default=0)
    height = models.IntegerField(verbose_name="图片高度", default=0)
    create_time = models.DateTimeField(verbose_name=u'创建时间', default=timezone.now)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)
