# -*- coding: utf8 -*-

from __future__ import unicode_literals, absolute_import, print_function

from talos.libs.utils import ObjFromDict
from talos.rpc import get_current_rpc_invoker


def get_share_by_share_id(id):
    if not id:
        return

    r = get_current_rpc_invoker()

    try:
        result = r['api/share/by_id'](id=id).unwrap()
    except Exception:
        return None

    return ObjFromDict(result)


def get_location_tag_id_by_city_id(city_id):
    if not city_id:
        return None, None

    r = get_current_rpc_invoker()
    try:
        result = r['api/city/city_and_country_tag_id'](city_id=city_id).unwrap()
    except Exception:
        return None, None
    return result


def get_province_info_by_province_id(province_id):
    r = get_current_rpc_invoker()
    try:
        result = r['api/province/info'](id=province_id).unwrap()
    except Exception:
        return None
    return ObjFromDict(result)


def add_points(reason_type):
    r = get_current_rpc_invoker()
    res = r['api/pointsinfo/add'](reason_type=reason_type).unwrap()
    return res['points']


def get_user_lastest_device_app_version_by_user_id(user_id):
    r = get_current_rpc_invoker()
    try:
        version = r['api/device/user_app_version'](user_id=user_id).unwrap()
    except Exception:
        return "0.0.0"
    return version
