-- Deploy mimas-talos:2019_05_09_create_doctor_soft_article to mysql

BEGIN;

CREATE TABLE `api_doctor_softarticle` (`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY, `doctor_id` varchar(64) NOT NULL, `merchant_id` varchar(64) NOT NULL, `content` longtext NOT NULL, `title` varchar(32) NOT NULL, `is_online` bool NOT NULL, `status` varchar(12) NOT NULL, `platform` varchar(12) NOT NULL, `content_level` varchar(12) NOT NULL, `article_type` integer NOT NULL, `hera_is_online` bool NOT NULL, `create_time` datetime(6) NOT NULL, `online_time` datetime(6) NOT NULL, `show_order` integer NOT NULL, `last_modified` datetime(6) NOT NULL, `audit_time` datetime(6) NULL);

CREATE TABLE `api_softarticle_check` (`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY, `softarticle_id` integer NOT NULL, `user_id` integer NULL, `content_level` varchar(12) NOT NULL, `status` varchar(12) NOT NULL, `check_content` longtext NOT NULL, `check_time` datetime(6) NOT NULL, `is_online` bool NOT NULL, `online_time` datetime(6) NULL, `create_time` datetime(6) NOT NULL, `update_time` datetime(6) NOT NULL);

CREATE TABLE `api_doctor_softarticle_extra` (`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY, `softarticle_id` integer NOT NULL UNIQUE, `reply_count` integer NOT NULL, `vote_count` integer NOT NULL, `favor_count` integer NOT NULL);

CREATE TABLE `api_softarticle_favor` (`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY, `softarticle_id` integer NOT NULL, `user_id` integer NOT NULL, `is_deleted` bool NOT NULL, `is_read` bool NOT NULL, `create_time` datetime(6) NOT NULL, `update_time` datetime(6) NOT NULL);

CREATE TABLE `api_softarticle_images` (`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY, `softarticle_id` integer NOT NULL, `image_url` varchar(300) NOT NULL, `width` integer NOT NULL, `height` integer NOT NULL, `create_time` datetime(6) NOT NULL, `update_time` datetime(6) NOT NULL);

CREATE TABLE `api_doctor_softarticle_relation` (`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY, `softarticle_id` integer NOT NULL, `relation_id` integer NOT NULL, `relation_type` integer NOT NULL);

CREATE TABLE `api_softarticle_reply` (`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY, `softarticle_id` integer NOT NULL, `user_id` integer NULL, `merchant_id` varchar(64) NOT NULL, `doctor_id` varchar(64) NULL, `top_id` integer NOT NULL, `replied_id` integer NOT NULL, `content` varchar(512) NOT NULL, `is_read` bool NOT NULL, `vote_num` integer NOT NULL, `source_id` varchar(12) NOT NULL, `is_reply` bool NOT NULL, `is_vote` bool NOT NULL, `is_online` bool NOT NULL, `create_time` datetime(6) NOT NULL, `update_time` datetime(6) NOT NULL);

CREATE TABLE `api_softarticle_reply_vote` (`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY, `softarticle_id` integer NOT NULL, `user_id` integer NOT NULL, `reply_id` integer NOT NULL, `is_read` bool NOT NULL, `is_fake` bool NOT NULL, `is_online` bool NOT NULL, `create_time` datetime(6) NOT NULL, `update_time` datetime(6) NOT NULL);

CREATE TABLE `api_doctor_softarticle_video` (`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY, `softarticle_id` integer NOT NULL, `video_cover_url` varchar(300) NOT NULL, `width` integer NOT NULL, `height` integer NOT NULL, `upload_img_cover` varchar(300) NOT NULL, `raw_video_url` varchar(128) NOT NULL, `water_video_url` varchar(128) NOT NULL, `persistent_id` varchar(128) NOT NULL, `persistent_status` integer NOT NULL, `is_online` bool NOT NULL, `create_time` datetime(6) NOT NULL, `update_time` datetime(6) NOT NULL);

CREATE TABLE `api_softarticle_vote` (`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY, `softarticle_id` integer NOT NULL, `user_id` integer NOT NULL, `is_read` bool NOT NULL, `is_fake` bool NOT NULL, `is_online` bool NOT NULL, `create_time` datetime(6) NOT NULL, `update_time` datetime(6) NOT NULL);


ALTER TABLE `api_softarticle_vote` ADD CONSTRAINT `api_softarticle_vote_user_id_1903fbf1_uniq` UNIQUE (`user_id`, `softarticle_id`);

ALTER TABLE `api_softarticle_reply_vote` ADD CONSTRAINT `api_softarticle_reply_vote_user_id_9f3779e6_uniq` UNIQUE (`user_id`, `softarticle_id`, `reply_id`);

ALTER TABLE `api_softarticle_favor` ADD CONSTRAINT `api_softarticle_favor_user_id_b970cf3e_uniq` UNIQUE (`user_id`, `softarticle_id`);


CREATE INDEX `api_doctor_softarticle_d4d6bd50` ON `api_doctor_softarticle` (`doctor_id`);
CREATE INDEX `api_doctor_softarticle_2bfddeac` ON `api_doctor_softarticle` (`merchant_id`);
CREATE INDEX `api_softarticle_check_97f6021a` ON `api_softarticle_check` (`softarticle_id`);
CREATE INDEX `api_softarticle_images_97f6021a` ON `api_softarticle_images` (`softarticle_id`);
CREATE INDEX `api_softarticle_reply_97f6021a` ON `api_softarticle_reply` (`softarticle_id`);
CREATE INDEX `api_softarticle_reply_e8701ad4` ON `api_softarticle_reply` (`user_id`);
CREATE INDEX `api_softarticle_reply_2bfddeac` ON `api_softarticle_reply` (`merchant_id`);
CREATE INDEX `api_softarticle_reply_d4d6bd50` ON `api_softarticle_reply` (`doctor_id`);
CREATE INDEX `api_softarticle_reply_fb6fedd0` ON `api_softarticle_reply` (`top_id`);
CREATE INDEX `api_softarticle_reply_90ea0cfb` ON `api_softarticle_reply` (`replied_id`);
CREATE INDEX `api_softarticle_reply_vote_97f6021a` ON `api_softarticle_reply_vote` (`softarticle_id`);
CREATE INDEX `api_softarticle_reply_vote_bbc2f847` ON `api_softarticle_reply_vote` (`reply_id`);
CREATE INDEX `api_doctor_softarticle_video_97f6021a` ON `api_doctor_softarticle_video` (`softarticle_id`);
CREATE INDEX `api_softarticle_vote_97f6021a` ON `api_softarticle_vote` (`softarticle_id`);

COMMIT;
