-- Deploy mimas-talos:talos_2019_03_28_create_table_tractate to mysql

BEGIN;
CREATE TABLE `api_tractate` (
	`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
	`user_id` INT NOT NULL,
	`content` longtext NOT NULL,
	`is_online` bool NOT NULL,
	`status` varchar(12) NOT NULL,
	`platform` varchar(12) NOT NULL,
	`content_level` varchar(12) NOT NULL,
	`is_excellent` bool NOT NULL,
	`create_time` datetime(6) NOT NULL,
	`last_modified` datetime(6) NOT NULL
);

CREATE TABLE `api_tractate_extra` (
	`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
	`tractate_id` integer NOT NULL UNIQUE,
	`reply_count` integer NOT NULL,
	`vote_count` integer NOT NULL,
	`favor_count` integer NOT NULL
);

CREATE TABLE `api_tractate_favor` (
	`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
	`tractate_id` integer NOT NULL,
	`user_id` integer NOT NULL,
	`create_time` datetime(6) NOT NULL,
	`update_time` datetime(6) NOT NULL,
	`is_deleted` bool NOT NULL
);

CREATE TABLE `api_tractate_images` (
	`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
	`tractate_id` integer NOT NULL,
	`image_url` varchar(300) NOT NULL,
	`create_time` datetime(6) NOT NULL,
	`update_time` datetime(6) NOT NULL
);

CREATE TABLE `api_tractate_tag` (
	`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
	`tractate_id` integer NOT NULL,
	`tag_id` INT NOT NULL,
	`create_time` datetime(6) NOT NULL,
	`update_time` datetime(6) NOT NULL
);

CREATE TABLE `api_tractate_video` (
	`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
	`tractate_id` integer NOT NULL,
	`raw_video_url` varchar(128) NOT NULL,
	`water_video_url` varchar(128) NOT NULL,
	`persistent_id` varchar(128) NOT NULL,
	`persistent_status` integer NOT NULL,
	`is_online` bool NOT NULL,
	`create_time` datetime(6) NOT NULL,
	`update_time` datetime(6) NOT NULL
);

ALTER TABLE `api_tractate_favor` ADD CONSTRAINT `api_tractate_favor_user_id_0938725f_uniq` UNIQUE (`user_id`, `tractate_id`);

CREATE INDEX `api_tractate_images_5f3745c8` ON `api_tractate_images` (`tractate_id`);
CREATE INDEX `api_tractate_tag_5f3745c8` ON `api_tractate_tag` (`tractate_id`);
CREATE INDEX `api_tractate_video_5f3745c8` ON `api_tractate_video` (`tractate_id`);

COMMIT;
