# -*- coding: UTF-8 -*-
from gm_types.gaia import DOCTOR_TYPE

from utils.rpc import rpc_client
from talos.services import DoctorService
from talos.services import UserService


def get_username_with_title(user_id):
    user = UserService.get_user_by_user_id(user_id=user_id)
    if not user:
        return u''

    if user.id == 22:
        return user.nickname
    try:
        doctor = DoctorService.get_doctor_by_user_id(user_id=user_id)
    except IndexError:
        doctor = None
    if doctor:
        if doctor.doctor_type == DOCTOR_TYPE.OFFICER:
            who = doctor.name

        else:
            who = u'{} 医生'.format(doctor.name)

    else:
        who = user.nickname

    return who


def get_auth_type_by_userid(user_id):
    if user_id:
        return rpc_client['api/user/auth_type'](uid=user_id).unwrap()
    else:
        return ''


