from django.conf import settings

from gm_rpcd.all import bind
from gm_types.error import ERROR

from social.models import UserFollow
from talos.manager import diary_list_manager
from talos.models.diary import Diary
from utils.rpc import gen, get_current_user


@bind('mimas/user/follow/diary/list')
def user_follow_diary_list(offset=0, count=10):
    """
    关注的用户的日记本
    :param user_id:
    :param offset:
    :param count:
    :return:
    """
    user = get_current_user()
    if not user:
        return gen(ERROR.LOGIN_REQUIRED)

    user_follow_ids = list(UserFollow.objects.filter(
        user_id=user.id, bond=True).order_by('-id').values_list('follow_id', flat=True))
    diaries = Diary.objects.using(settings.SLAVE_DB_NAME).filter(user_id__in=user_follow_ids, is_online=True
                                   ).order_by('-id')[offset: offset+count]

    return diary_list_manager.get_diary_list_by_diary_objs(
        diaries, viewer_user_id=user.id, need_service=False
    )

