# coding:utf-8

import json

from django.conf import settings
from gm_types.gaia import TAG_TYPE

from talos.services import UserService
from talos.rpc import bind
from talos.models.diary import Diary
from talos.models.sitemap import SiteMap


def build_title(username, diary_id, tags):

    title = u'%s的更美日记' % username

    for tag in tags:
        if tag.tag_type in [TAG_TYPE.BODY_PART,
                           TAG_TYPE.BODY_PART_SUB_ITEM,
                           TAG_TYPE.ITEM_WIKI]:
            tag_name = tag.name
            last_digit = str(diary_id)[-1]
            if last_digit in ['1', '3']:
                title = u'{tag}手术,恢复,过程_{user}'.format(
                    tag=tag_name,
                    user=username
                )
            elif last_digit in ['0', '2']:
                title = u'{tag}前后对比图_{user}'.format(
                    tag=tag_name,
                    user=username
                )
            elif last_digit in ['5', '7']:
                title = u'{tag}多少钱_{user}'.format(
                    tag=tag_name,
                    user=username
                )
            elif last_digit in ['4', '6']:
                title = u'{tag}价格_{user}'.format(
                    tag=tag_name,
                    user=username
                )
            else:
                title = u'{tag}图片对比_{user}的{tag}日记'.format(
                    tag=tag_name,
                    user=username
                )

            break

    return title


def diaries_info(diaries, type):
    res = []
    for diary in diaries:
        me = UserService.get_user_by_user_id(diary.user_id)
        res.append({
            "title": build_title(me.nickname, diary.id, diary.tags),
            "id": diary.id,
            "created_time": diary.created_time,
            "type": type,
        })

    return res


def diaries_sitemap(content_level, offset=0, limit=10000):

    diaries = Diary.objects.using(settings.SLAVE_DB_NAME).filter(is_online=True, content_level=content_level).\
        extra({'created_time': "DATE_FORMAT(created_time, '%%Y-%%d-%%m')"}).only("id", "title", "created_time").order_by('-created_time')[offset: limit]

    return diaries_info(diaries, "diary")


def mip_diaries_sitemap(content_level, offset=0, limit=100000):

    diaries = Diary.objects.using(settings.SLAVE_DB_NAME).filter(content_level=content_level,
                                                                 bd_diary__isnull=False,
                                                                 bd_diary__is_submit=True). \
        extra({'created_time': "DATE_FORMAT(created_time, '%%Y-%%d-%%m')"}).only("id", "title", "created_time").order_by('-created_time')[offset: limit]

    return diaries_info(diaries, "mip_diary")


@bind('diary/sitemap/html')
def get_diary_sitemap(page_num, site_type):

    try:
        sitemap = SiteMap.objects.filter(page_num=page_num, site_type=site_type).get()
        return sitemap.data
    except SiteMap.DoesNotExist:
        return '[]'
