# coding=utf-8

from gm_rpcd.all import bind

from talos.views.diary.detail import get_diary_card_info_by_ids
from qa.portal import get_answers_by_ids
from utils.rpc import rpc_client, logging_exception


@bind('topic/column/get_cards')
def get_column_card_data(card_data_list):
    '''
    input: [{
        'card_type': 'service',
        'card_id': 'xx',
    }, ...]
    
    :return: 
        [{
        'card_type': 'service',
        'card_data': 'xx',
    }, ...]
    '''

    # 合并同类id 为 ids
    card_id_list_dict = {
        'service': [],  # api
        'hospital': [], # api
        'doctor': [],   # api
        'rankboard': [],    # api
        'service_list': [],  # api
        'answer': [],   # anser
        'diary': [],    # talos
    }
    for card_data in card_data_list:
        card_type = card_data['card_type']
        card_id = card_data['card_id']

        if card_type == 'text':
            continue

        card_id_list_dict[card_type].append(card_id)

    # call talos func
    talos_result = get_diary_card_info_by_ids(card_id_list_dict['diary'])

    # call answer rpc
    if card_id_list_dict['answer']:
        answer_result = get_answers_by_ids(ids=card_id_list_dict['answer'])
    else:
        answer_result = None

    # call api rpc
    api_data = []
    for t in ['service', 'hospital', 'doctor', 'rankboard', 'service_list']:
        api_data.append({
            'card_type': t,
            'id_list': card_id_list_dict[t],
        })
    try:
        api_result = rpc_client['api/get_cards_info'](data_list=api_data).unwrap()
    except:
        logging_exception()
        api_result = []

    # 根据结果重新组装，下线的pass
    result = []
    result_id_list_dict = {
        'service': [str(s['id']) for s in api_result['service']] if api_result else [],
        'hospital': [str(h['id']) for h in api_result['hospital']] if api_result else [],
        'doctor': [str(d['id']) for d in api_result['doctor']] if api_result else [],
        'rankboard': [str(r['id']) for r in api_result['rankboard']] if api_result else [],
        'service_list': [str(r['id']) for r in api_result['service_list']] if api_result else [],
        'answer': [str(a['answer_id']) for a in answer_result] if answer_result else [],
        'diary': [str(d['id']) for d in talos_result] if talos_result else [],
    }

    for c_data in card_data_list:
        c_type = c_data['card_type']
        c_id = str(c_data['card_id'])

        if c_type == 'text':
            result.append({
                'card_type': c_type,
                'card_data': c_id,
            })

        elif c_type == 'diary' and c_id in result_id_list_dict[c_type]:
            result.append({
                'card_type': c_type,
                'card_data': talos_result[result_id_list_dict['diary'].index(c_id)],
            })

        elif c_type == 'answer' and c_id in result_id_list_dict[c_type]:
            result.append({
                'card_type': c_type,
                'card_data': answer_result[result_id_list_dict['answer'].index(c_id)],
            })

        elif c_type in ['service', 'hospital', 'doctor', 'rankboard', 'service_list'] and \
                        c_id in result_id_list_dict[c_type]:
            result.append({
                'card_type': c_type,
                'card_data': api_result[c_type][result_id_list_dict[c_type].index(c_id)],
            })
        else:
            continue

    return result

