from django.db import models
from gm_types.push import PUSH_CONTENT_TYPE


class HotContent(models.Model):
    """热门内容，来源: 数据组统计 目前用于个性化push"""

    class Meta:
        verbose_name = '热门内容'
        db_table = 'api_hot_content'
        unique_together = ('date_index', 'content_type', 'content_id')

    date_index = models.DateField(u'统计日期', auto_now_add=True)
    content_id = models.IntegerField(u'内容id, 多个内容id拼接的字符串')
    content_type = models.CharField(u"内容类型", max_length=32, choices=PUSH_CONTENT_TYPE)
    click_num = models.IntegerField(u'点击数量')
    is_push = models.BooleanField(u'是否已经推送', default=False)
