#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.conf import settings
from django.db import models
from django.utils import timezone

from gm_types.mimas import (
    QUICK_SEARCH_CONTENT_DIVISION,
)


class QuickSearchContentKeyword(models.Model):
    class Meta:
        verbose_name = '内容详情页快速搜索关键字'
        db_table = 'api_quick_search_content_keyword'
        index_together = ['content_id', 'content_type']

    content_id = models.IntegerField(verbose_name="内容ID")
    content_type = models.CharField(verbose_name="内容类型", max_length=128, choices=QUICK_SEARCH_CONTENT_DIVISION)
    keywords = models.TextField(verbose_name="关键字，json数据")  # eg: '[{"keyword": "", "keyword_type": ''}]'
    create_time = models.DateTimeField(verbose_name="创建时间", default=timezone.now())
    update_time = models.DateTimeField(verbose_name="更新时间", default=timezone.now())
