#!/usr/bin/env python
# -*- coding: utf-8 -*-

from talos.services import (
    UserConvertService,
)
from social.models import SocialInfo
from utils.base_manager import BaseManager


class UserManager(BaseManager):

    def get_user_all_fans(self, user_id):
        """
        获取用户所有粉丝
        :param user_id:
        :return:
        """
        social_info = SocialInfo.social_info(user_id)

        fans_ids = []
        for fans_id in social_info.get_fans_iterator():
            fans_ids.append(fans_id)

        return fans_ids

    def _get_user_following_info(self, viewer_user_id, author_ids):
        """
        获取用户关注状态
        :param viewer_user_id: 查看的人
        :param author_ids: 作者id列表
        :return:
        """
        follow_rels = {}
        if viewer_user_id:
            social_info = SocialInfo(uid=viewer_user_id)
            follow_rels = social_info.is_following_users(author_ids)

        return follow_rels

    def _get_user_info_by_user_ids(self, user_ids, simple=True):
        """
        获取用户信息
        :param user_ids:
        :param simple:
        :return:
        """
        user_info_dic = UserConvertService.get_user_info_by_user_ids(user_ids, simple=simple)

        return user_info_dic

    def convert_user_info(self, viewer_user_id, author_ids, simple=True):
        """
        转化用户信息
        :param viewer_user_id:  查看者
        :param author_ids: 作者
        :param simple: 用户信息多or少的开关
        :return:
        """
        author_ids = self.filter_ids(author_ids)
        user_infos = self._get_user_info_by_user_ids(author_ids, simple=simple)
        follow_rels = self._get_user_following_info(viewer_user_id, author_ids)

        result = {}
        for k, _data in user_infos.items():
            _data.update({
                "is_following": follow_rels.get(k, False),
            })
            result[k] = _data

        return result


user_manager = UserManager()
