# -*- coding: UTF-8 -*-
from django.conf import settings
from gm_dbmw_api.descriptor import source, relation
from gm_types.mq.dbmw import DBMWEndPoints

pk_data_source = source.GroupedSource.of(
    source.MySQLTableSource(
        logical_database_id=settings.LOGICAL_DATABASE_ID,
        table_name='api_question',
        value_columns_all=True,
        key_columns=['id']
    ),
    source.MySQLTableSource(
        logical_database_id=settings.LOGICAL_DATABASE_ID,
        table_name='api_answer',
        key_columns=['question_id'],
        value_columns_all=True,
    ),
    source.RelatedSource(
        source=source.GMMQSource(
            endpoint=DBMWEndPoints.GAIA_TAG,
        ),
        relation=relation.MySQLTableRelation(
            logical_database_id=settings.LOGICAL_DATABASE_ID,
            table_name='api_questiontag',
            from_columns=['tag_id'],
            to_columns=['question_id'],
        )
    ),
    source.RelatedSource(
        source=source.GroupedSource.of(
            source.MySQLTableSource(
                logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                table_name="api_doctor",
                key_columns=['user_id'],
                value_columns_excluded=['view_num', 'reply_num', 'new_pm_num', 'reply_pm_num', 'no_reply_pm_num',
                                        'share_topic_num', 'last_answered_time'],
                value_columns_all=True,
            ),
            source.RelatedSource(
                source=source.GMMQSource(
                    endpoint=DBMWEndPoints.PUNISHMENT_TRIGGER,
                ),
                relation=relation.MySQLTableRelation(
                    logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                    table_name="api_doctor",
                    from_columns=["id"],
                    to_columns=["user_id"],
                )
            )
        ),
        relation=relation.MySQLTableRelation(
            logical_database_id=settings.LOGICAL_DATABASE_ID,
            table_name='api_question',
            from_columns=['user_id'],
            to_columns=['id'],
        )
    ),
    source.GMMQSource(
        endpoint=DBMWEndPoints.QUESTION_TRIGGER,
    )
)

index_data_source = pk_data_source
