import logging
from datetime import datetime

from talos.services.subscript_article import SubscriptArticleService
from data_sync.utils import tzlc


def get_subscript_article(pks):

    articles = SubscriptArticleService.list_by_ids(article_ids=pks)

    data = []
    for article in articles:
        item = {}
        item['id'] = article["id"]
        item["title"] = article["title"]
        item["name"] = article["name"]
        # item["url"] = article["url"]

        # item["image_url"] = article["image_url"]
        # item["share_img"] = article["share_img"]
        item["share_content"] = article["share_content"]

        item["is_online"] = article["is_online"]
        item["is_header_article"] = article["is_header_article"]

        item["platform"] = article["platform"]
        item["ordering"] = article["ordering"]

        item["create_time"] = tzlc(datetime.fromtimestamp(article["create_time"]))
        item["create_time_val"] = article["create_time"]

        item["update_time"] = tzlc(datetime.fromtimestamp(article["update_time"]))
        item["update_time_val"] = article["update_time"]

        tag_list = SubscriptArticleService.list_tags_by_id(article["id"])
        item["tags"] = [item.id for item in tag_list]
        item["tag_names"] = [item.name for item in tag_list]

        categories = SubscriptArticleService.list_category_by_id(article["id"])
        item["categories"] = [item["id"] for item in categories]
        item["category_names"] = [item["name"] for item in categories]

        data.append(item)

    return data
