
from gm_rpcd.all import bind
from social.models import UserFollow
from .schema import schema_view
from data_sync.answer import get_answers_rpc
from data_sync.answer import get_answer_ids


@bind('mimas/sync/user_follow')
def sync_user_follow(items):
    """

    :param items:
    :return:
    """
    for obj in items:
        fid = obj.pop('id')
        UserFollow.objects.update_or_create(id=fid, defaults=obj)


@bind('mimas/meta/schema')
def get_schema(app_label=None, db_table=None):
    return schema_view(app_label, db_table)

@bind('mimas/sync/answer')
def answer(ids):
    result = get_answers_rpc(ids.split())
    return result

@bind('mimas/sync/question_answer')
def question_answer(ids):
    result = get_answer_ids(ids.split())
    return result
