# -*- coding: utf-8 -*-
import logging

from django.core.management import BaseCommand

from live.models import LiveChannel
from utils.rpc import get_rpc_invoker


class Command(BaseCommand):
    """ Import famous doctor award list from txt to database """

    def handle(self, *args, **options):
        channels = LiveChannel.objects.all()
        print(len(channels))
        rpc = get_rpc_invoker()
        for channel in channels:
            person_id = channel.person_id
            try:
                result = rpc['api/person/user_info'](person_id=person_id).unwrap()
                channel.user_id = result.get("user_id")
                channel.save()
            except:
                logging.info("{pserson_id}找不到对应的user_id".format(channel.person_id))
