from gm_rpcd.all import bind
from qa.models import AnswerReply
from qa.tasks import comment_push, applet_replied_push
from qa.serializers import AnswerReplySerializer
from utils.rpc import gen
from gm_types.error import ERROR as CODES


@bind("mimas/hera_answer/reply_list")
def reply_list(answer_id, size=10, first_reply=0, last_id=0):
    """
    获取回答评论，一级评论按照时间先后排序，二级评论跟着一级评论后
    :param answer_id: 帖子id
    :param size:
    :param first_reply: 一级评论id
    :param last_id: 最后一条评论的id
    :return:
    """
    reply_infos = []
    # 第一次查询
    if not last_id:
        # 获取size条一级和次级评论
        reply_infos = AnswerReply.get_replys(answer_id, last_id, size)
    else:
        # 获取当前一级评论剩余的次级评论 size 条
        sub_reply_info_list = list(AnswerReply.objects.filter(
            answer_id=answer_id,
            first_reply_id=first_reply or last_id,
            is_online=True,
            id__gt=last_id,
        )[0: size])

        reply_infos.extend(sub_reply_info_list)

        # 如果总数小于size 往后查 size-len(reply_infos)条 一级和次级评论
        last_id = first_reply or last_id
        if len(reply_infos) < size:
            _reply_infos = AnswerReply.get_replys(answer_id, last_id, size - len(reply_infos))
            reply_infos.extend(_reply_infos)

    if not reply_infos:
        return []

    reply_list = []

    for reply in reply_infos:
        reply_info =  reply.to_dict()
        reply_list.append(reply_info)

    return reply_list


@bind("mimas/hera_answer/create_reply")
def create_reply(content, user_id, answer_id, reply_id=None):
    """hera后台创建评论和回复"""
    data = {
        'user': user_id,
        'content': content,
        'answer': answer_id,
        'commented_reply': reply_id,
        'is_fake': True,
    }
    serializer = AnswerReplySerializer(data=data)
    if not serializer.is_valid(raise_exception=False):
        return gen(CODES.CONTENT_CREATE_ERROR)
    answer_reply = serializer.save()

    # 给被评论的人发送push请求 没有被评论的默认为回答人
    push_user_id = answer_reply.commented_reply.user_id if reply_id else answer_reply.answer.user_id
    if user_id != push_user_id:
        comment_push(
            answer_id=answer_id,
            comment_id=answer_reply.id,
            author_name=answer_reply.user.nickname,
            content=content,
            user_id=push_user_id,
            is_commented_reply=True if reply_id else False
        )

    # 给被评论的评论用户发小程序push
    applet_replied_push.delay(answer_reply.id)
    return "回复成功" if reply_id else "评论成功"


@bind("mimas/hera_answer/delete_reply")
def delete_reply(reply_id):
    """hera后台创建评论和回复"""
    try:
        answer_reply = AnswerReply.objects.get(id=reply_id)
    except AnswerReply.DoesNotExist:
        return "评论不存在"

    answer_reply.is_online = False
    answer_reply.save()

    # 如果是一级评论 则将first_reply_id为当前评论id的评论下线
    first_reply_id = answer_reply.first_reply_id
    if not first_reply_id:

        AnswerReply.objects.filter(first_reply_id=reply_id).update(is_online=False)

    # 如果是次级评论，则将commented_reply_id为当前评论id的评论下线 以及commented_reply_id为下线评论id的评论下线
    else:
        sub_reply_id_list = AnswerReply.get_sub_reply_ids(reply_id)
        if sub_reply_id_list:
            AnswerReply.objects.filter(id__in=sub_reply_id_list).update(is_online=False)

    return "删除成功"